/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Zone
implements Iterable<Resource> {
    public static String defaultZoneName = "default zone";
    public static final int DEFAULT_ZONE_ID = 0;
    private final int zoneId;
    private Set<Resource> resources;
    private String zoneName;
    private transient Network parent;
    private transient boolean ready = false;

    protected Zone(int zoneId, Network parent) {
        this.zoneId = zoneId;
        this.parent = parent;
    }

    public int getId() {
        return this.zoneId;
    }

    public String getName() {
        return this.zoneName;
    }

    public Set<Resource> getResources() {
        if (null == this.resources) {
            this.resources = Collections.synchronizedSet(new HashSet());
        }
        return this.resources;
    }

    public Network getParent() {
        return this.parent;
    }

    public void setName(String name, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.SetZone(this, name), listener);
    }

    protected void internalAddResource(Resource resource) {
        this.getResources().add(resource);
    }

    protected void internalRemoveResource(Resource resource) {
        this.getResources().remove(resource);
    }

    protected boolean containsResource(Resource resource) {
        return this.getResources().contains(resource);
    }

    protected void internalSetName(String name) {
        this.zoneName = name;
    }

    protected void internalMarkAsReady() {
        this.ready = true;
    }

    protected void internalSetParent(Network parent) {
        this.parent = parent;
    }

    public final int hashCode() {
        return this.getId();
    }

    public boolean isReady() {
        return this.ready;
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.getResources().iterator();
    }

    public String toString() {
        String networkId = null == this.parent ? "?" : this.parent.getId();
        return "Zone{networkId=" + networkId + ", zoneId=" + this.zoneId + ", resources=" + this.resources + ", zoneName='" + this.zoneName + '\'' + ", ready=" + this.ready + '}';
    }
}

