/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.client;

import cc.kkon.gmhttps.client.ClientBuilder;
import cc.kkon.gmhttps.client.Response0;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public class SSLRequests {
    private static final HttpClient client = ClientBuilder.initGMSSL();
    private static final String ENCODING = "UTF-8";
    private static final int timeout = 30000;

    public static Response0 post(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        SSLRequests.putHeaders((HttpRequestBase)httpPost, headers);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        if (MapUtils.isNotEmpty(params)) {
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                list.add(new BasicNameValuePair(key, params.get(key)));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, ENCODING));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        Response0 res0 = new Response0(response);
        httpPost.abort();
        return res0;
    }

    public static Response0 post4json(String url, String json, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        SSLRequests.putHeaders((HttpRequestBase)httpPost, headers);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        Response0 res0 = new Response0(response);
        httpPost.abort();
        return res0;
    }

    public static Response0 get(String url) throws IOException {
        return SSLRequests.get(url, null, null);
    }

    public static Response0 get(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpGet httpGet = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (params != null && params.size() != 0) {
                LinkedList<BasicNameValuePair> list = new LinkedList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                uriBuilder.setParameters(list);
            }
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
        httpGet.setConfig(requestConfig);
        httpGet.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        SSLRequests.putHeaders((HttpRequestBase)httpGet, headers);
        HttpResponse response = client.execute((HttpUriRequest)httpGet);
        Response0 res0 = new Response0(response);
        httpGet.abort();
        return res0;
    }

    private static void putHeaders(HttpRequestBase httpMethod, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

