/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.server;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

class ReadLine {
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte CR = 13;
    public static final byte LF = 10;
    private static final int LINE_MAX_SIZE = 16384;

    ReadLine() {
    }

    public static byte[] read(DataInputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream s = new DataOutputStream(baos);
        boolean previousIsCR = false;
        int len = 0;
        byte b = 0;
        try {
            b = in.readByte();
            ++len;
        }
        catch (EOFException e) {
            return null;
        }
        while (true) {
            if (b == 10) {
                if (previousIsCR) {
                    s.flush();
                    byte[] rs = baos.toByteArray();
                    s.close();
                    return rs;
                }
                s.flush();
                byte[] rs = baos.toByteArray();
                s.close();
                return rs;
            }
            if (b == 13) {
                if (previousIsCR) {
                    s.writeByte(13);
                }
                previousIsCR = true;
            } else {
                if (previousIsCR) {
                    s.writeByte(13);
                }
                previousIsCR = false;
                s.write(b);
            }
            if (len > 16384) {
                s.close();
                throw new IOException("Reach line size limit");
            }
            try {
                b = in.readByte();
                ++len;
            }
            catch (EOFException e) {
                s.flush();
                byte[] rs = baos.toByteArray();
                s.close();
                return rs;
            }
        }
    }
}

