/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Strings
extends StringUtils {
    public static final String COMMA = ",";
    private static final Pattern PATTERN = Pattern.compile("\\+");
    private static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");

    public static void ifEmpty(String source, Runnable r) {
        if (Strings.isEmpty((CharSequence)source)) {
            r.run();
        }
    }

    public static void ifNotEmpty(String source, Consumer<String> consumer) {
        if (Strings.isNotEmpty((CharSequence)source)) {
            consumer.accept(source);
        }
    }

    public static void ifContains(String source, String sub, Consumer<Integer> consumer) {
        int idx;
        if (Strings.isNotEmpty((CharSequence)source) && (idx = source.indexOf(sub)) != -1) {
            consumer.accept(idx);
        }
    }

    public static String htmlSpecialCharsEncode(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public static String firstLetterToUpper(String str) {
        return str != null && str.length() >= 1 ? Character.toUpperCase(str.charAt(0)) + str.substring(1) : str;
    }

    public static String encodeUri(String source) {
        if (Strings.isEmpty((CharSequence)source)) {
            return "";
        }
        try {
            String res = URLEncoder.encode(source, StandardCharsets.UTF_8.displayName());
            return PATTERN.matcher(res).replaceAll("%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String decodeUri(String source) {
        try {
            return Strings.isEmpty((CharSequence)source) ? "" : URLDecoder.decode(source, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String toStr(Object o) {
        return o == null ? "" : o.toString();
    }

    public static Integer toInteger(Object o) {
        try {
            if (o == null || "".equals(o.toString().trim())) {
                return null;
            }
            return Integer.parseInt(o.toString().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static <T> List<T> trans(Object list) {
        return (List)list;
    }

    public static String[] split(String str, String sep) {
        if (Strings.isEmpty((CharSequence)str)) {
            return new String[0];
        }
        return (String[])Arrays.stream(str.split(sep)).filter(StringUtils::isNotEmpty).toArray(String[]::new);
    }

    public static String[] split(String str) {
        return Strings.split(str, COMMA);
    }

    public static List<String> split2list(String str, String sep) {
        LinkedList<String> list = new LinkedList<String>();
        if (Strings.isEmpty((CharSequence)str)) {
            return list;
        }
        String[] split = Strings.split(str, sep);
        list.addAll(Arrays.asList(split));
        return list;
    }

    public static List<String> split2list(String str) {
        return Strings.split2list(str, COMMA);
    }

    public static String join(int[] ints, String sep) {
        return Arrays.stream(ints).boxed().map(String::valueOf).collect(Collectors.joining(sep));
    }

    public static String getNotEmpty(String v1, String v2) {
        return Strings.isNotEmpty((CharSequence)v1) ? v1 : v2;
    }

    public static boolean equalsAny(CharSequence cs, CharSequence ... css) {
        if (Strings.isEmpty((CharSequence)cs) || ArrayUtils.isEmpty((Object[])css)) {
            return false;
        }
        for (CharSequence ce : css) {
            if (!cs.equals(ce)) continue;
            return true;
        }
        return false;
    }

    public static String hump2line(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String line2hump(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        str = str.toLowerCase();
        Matcher matcher = LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String addZero(String str, int length) {
        if (str == null) {
            str = "";
        }
        StringBuilder sb = new StringBuilder();
        int diff = length - str.length();
        for (int i = 0; i < diff; ++i) {
            sb.append("0");
        }
        return sb + str;
    }

    public static String addZero(int i, int length) {
        return Strings.addZero(i + "", length);
    }

    public static String getAbsolutePath(String root, String relativePath) {
        String[] split2;
        String sep = "/";
        String path1 = root.replaceAll("\\\\", sep);
        String path2 = relativePath.replaceAll("\\\\", sep);
        if (path1.endsWith(sep)) {
            path1 = path1.substring(0, path1.length() - 1);
        }
        for (String s : split2 = Strings.split(path2, sep)) {
            if (s.equals("..")) {
                path1 = path1.substring(0, path1.lastIndexOf(sep));
                path2 = path2.substring(path2.indexOf(sep) + 1);
                continue;
            }
            if (s.equals(".")) {
                path2 = path2.substring(path2.indexOf(sep) + 1);
                continue;
            }
            return path1 + sep + path2;
        }
        throw new RuntimeException("ERR");
    }
}

