/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.server;

import cc.kkon.gmhttps.model.ServerConfig;
import cc.kkon.gmhttps.server.ConnectRunner;
import cc.kkon.gmhttps.utils.Utils;
import cn.gmssl.jce.provider.GMJCE;
import cn.gmssl.jsse.provider.GMJSSE;
import java.io.Closeable;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.IOUtils;

public class AcceptRunner
implements Runnable,
Closeable {
    private final ServerConfig cfg;
    private final ExecutorService threadPool;
    private final Map<String, HttpServlet> servlets;
    private volatile boolean closed;
    private SSLServerSocket sslServerSocket;

    public AcceptRunner(ServerConfig cfg, Map<String, HttpServlet> servlets) {
        this.cfg = cfg;
        this.servlets = servlets;
        this.threadPool = Executors.newFixedThreadPool(cfg.threadCount);
    }

    @Override
    public void run() {
        try {
            this.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void listen() throws Exception {
        Security.insertProviderAt((Provider)new GMJCE(), 1);
        Security.insertProviderAt((Provider)new GMJSSE(), 2);
        KeyStore pfx = KeyStore.getInstance("PKCS12", "GMJSSE");
        char[] certPwdBytes = this.cfg.certPassword.toCharArray();
        pfx.load(this.cfg.cert, certPwdBytes);
        SSLServerSocketFactory fact = Utils.createServerSocketFactory(pfx, certPwdBytes);
        this.sslServerSocket = (SSLServerSocket)fact.createServerSocket(this.cfg.port);
        this.sslServerSocket.setNeedClientAuth(this.cfg.twoWayAuth);
        System.out.println("listening...");
        while (!this.closed) {
            try {
                System.out.println("client comes");
                SSLSocket socket = (SSLSocket)this.sslServerSocket.accept();
                ConnectRunner runner = new ConnectRunner(this.cfg, socket, this.servlets);
                this.threadPool.execute(runner);
            }
            catch (SocketException e) {
                System.out.println("SSLServerSocket closed, " + this.cfg.port + " released.");
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        IOUtils.closeQuietly((InputStream)this.cfg.cert);
        IOUtils.closeQuietly((ServerSocket)this.sslServerSocket);
        this.threadPool.shutdown();
    }
}

