/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.server;

import cc.kkon.gmhttps.model.ServerConfig;
import cc.kkon.gmhttps.server.servelt.DefaultHttpServletRequest;
import cc.kkon.gmhttps.server.servelt.DefaultHttpServletResponse;
import cc.kkon.gmhttps.utils.ReadLine;
import cc.kkon.gmhttps.utils.Strings;
import cc.kkon.gmhttps.utils.Utils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.IOUtils;

public class ConnectRunner
implements Runnable,
Closeable {
    private final ServerConfig cfg;
    private final Map<String, HttpServlet> servlets;
    private final SSLSocket socket;
    private DataOutputStream out;

    public ConnectRunner(ServerConfig cfg, SSLSocket socket, Map<String, HttpServlet> servlets) {
        this.cfg = cfg;
        this.servlets = servlets;
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            this.doConnect(this.socket);
        }
        catch (SSLHandshakeException e) {
            System.out.println("Bad request: " + e.getMessage());
        }
        catch (IOException | ServletException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Socket)this.socket);
        }
    }

    private void doConnect(SSLSocket socket) throws ServletException, IOException {
        byte[] lineBuf;
        DataInputStream in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        boolean get = false;
        LinkedList<String> reqHeadLines = new LinkedList<String>();
        while ((lineBuf = ReadLine.read(in)) != null && lineBuf.length != 0) {
            String line = new String(lineBuf);
            if (!get) {
                get = line.startsWith("GET ");
            }
            reqHeadLines.add(line);
        }
        String contentLength = Utils.buildHeaders(reqHeadLines).get("Content-Length");
        byte[] buf = new byte[]{};
        if (!get && Strings.isNotEmpty((CharSequence)contentLength)) {
            int len = Integer.parseInt(contentLength);
            buf = new byte[len];
            in.read(buf);
        }
        DefaultHttpServletRequest req = new DefaultHttpServletRequest(reqHeadLines, buf);
        DefaultHttpServletResponse resp = new DefaultHttpServletResponse();
        String reqURI = req.getRequestURI();
        HttpServlet servlet = this.servlets.get(reqURI);
        if (servlet == null) {
            // empty if block
        }
        servlet.service((ServletRequest)req, (ServletResponse)resp);
        this.writeResponseMessage(resp);
        if (this.cfg.twoWayAuth) {
            X509Certificate[] cs = socket.getSession().getPeerCertificateChain();
            System.out.println("client certs len=" + cs.length);
            for (X509Certificate c : cs) {
                System.out.println(c);
            }
        }
    }

    private void writeResponseMessage(DefaultHttpServletResponse resp) {
        try {
            byte[] bytes = resp.buildResponseMessage();
            this.out.write(bytes);
            this.out.flush();
            IOUtils.closeQuietly((OutputStream)this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

