/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.gmhttps.server.servelt;

import cc.kkon.gmhttps.model.FirstLine;
import cc.kkon.gmhttps.utils.Strings;
import cc.kkon.gmhttps.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class DefaultHttpServletRequest
implements HttpServletRequest {
    private final FirstLine fl;
    private final Map<String, String> headers;
    private final Map<String, List<String>> params;
    private final byte[] body;

    public DefaultHttpServletRequest(List<String> headLines, byte[] body) {
        String firstLine = headLines.remove(0);
        this.fl = Utils.parse1stLine(firstLine);
        this.headers = Utils.buildHeaders(headLines);
        Map<String, List<String>> urlParams = null;
        Map<String, List<String>> bodyParams = null;
        this.body = body;
        String url = this.fl.url;
        if (url.contains("?")) {
            String paramsStr = url.split("\\?")[1];
            urlParams = Utils.parseParams(paramsStr);
        }
        String type = this.getContentType();
        if (body.length != 0 && Strings.isNotBlank((CharSequence)type) && type.startsWith("application/x-www-form-urlencoded")) {
            String con = new String(body, StandardCharsets.UTF_8);
            bodyParams = Utils.parseParams(con);
        }
        this.params = Utils.merge(urlParams, bodyParams);
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String s) {
        throw new RuntimeException("Not support now");
    }

    public String getHeader(String s) {
        return this.headers.get(s);
    }

    public Enumeration<String> getHeaders(String s) {
        throw new RuntimeException("Not support now");
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String s) {
        throw new RuntimeException("Not support now");
    }

    public String getMethod() {
        return this.fl.method;
    }

    public String getPathInfo() {
        throw new RuntimeException("Not support now");
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.getRequestURL().toString();
    }

    public StringBuffer getRequestURL() {
        String url = this.fl.url;
        int i = url.indexOf("?");
        if (i != -1) {
            url = url.substring(0, i);
        }
        return new StringBuffer(url);
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String s) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String s) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return (int)this.getContentLengthLong();
    }

    public long getContentLengthLong() {
        String len = this.headers.getOrDefault("Content-Length", "0");
        return Long.parseLong(len);
    }

    public String getContentType() {
        return this.headers.get("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String s) {
        if (this.params.containsKey(s)) {
            return this.params.get(s).get(0);
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String s) {
        List<String> val = this.params.get(s);
        if (val == null) {
            return null;
        }
        return val.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> ent : this.params.entrySet()) {
            res.put(ent.getKey(), ent.getValue().toArray(new String[0]));
        }
        return res;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String s, Object o) {
    }

    public void removeAttribute(String s) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }
}

