/*
 * Decompiled with CFR 0.152.
 */
package cc.neckbeard.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class ExpiringFlag {
    private final int ttl;
    private final ChronoUnit unit;
    private Instant start;

    public ExpiringFlag(int ttl, ChronoUnit unit) {
        this(ttl, unit, true);
    }

    public ExpiringFlag(int ttl, ChronoUnit unit, boolean init) {
        if (unit == ChronoUnit.NANOS && ttl < 5000000 || unit == ChronoUnit.MICROS && ttl < 5000 || unit == ChronoUnit.MILLIS && ttl < 5) {
            throw new IllegalArgumentException("ExpiringBoolean timings smaller then 5 milliseconds are not supported due to inconsistency!");
        }
        this.ttl = ttl;
        this.unit = unit;
        this.start = init ? Instant.now() : Instant.ofEpochMilli(0L);
    }

    public boolean isValid() {
        return !this.start.plus((long)this.ttl, this.unit).isBefore(Instant.now());
    }

    public void reset() {
        this.start = Instant.now();
    }
}

