/*
 * Decompiled with CFR 0.152.
 */
package cc.neckbeard.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ExpiringSet<T>
implements Set<T> {
    private final Map<T, Instant> map = new ConcurrentHashMap<T, Instant>();
    private final int timeValue;
    private final ChronoUnit timeUnit;

    public ExpiringSet(int timeValue, ChronoUnit timeUnit) {
        if (timeUnit == ChronoUnit.NANOS || timeUnit == ChronoUnit.MICROS || timeUnit == ChronoUnit.MILLIS && timeValue < 5) {
            throw new IllegalArgumentException("ExpiringSet timings smaller then 5 milliseconds are not supported due to inconsistency!");
        }
        this.timeValue = timeValue;
        this.timeUnit = timeUnit;
    }

    private void removeExpired() {
        for (Map.Entry<T, Instant> entry : this.map.entrySet()) {
            if (!entry.getValue().plus((long)this.timeValue, this.timeUnit).isBefore(Instant.now())) continue;
            this.map.remove(entry.getKey());
        }
    }

    @Override
    public int size() {
        this.removeExpired();
        return this.map.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        this.removeExpired();
        return this.map.isEmpty();
    }

    @Override
    public boolean add(@NotNull T element) {
        return this.add(element, Instant.now());
    }

    public boolean add(@NotNull T element, @NotNull Instant instant) {
        this.removeExpired();
        this.map.put(element, instant);
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        return this.addAll(collection, Instant.now());
    }

    public boolean addAll(@NotNull Collection<? extends T> collection, @NotNull Instant instant) {
        this.removeExpired();
        for (T element : collection) {
            this.add(element, instant);
        }
        return true;
    }

    @Override
    public boolean contains(@NotNull Object element) {
        this.removeExpired();
        return this.map.containsKey(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        this.removeExpired();
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(@NotNull Object element) {
        this.removeExpired();
        int size = this.map.size();
        this.map.remove(element);
        return size != this.map.size();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        this.removeExpired();
        boolean changed = false;
        for (Object element : collection) {
            if (!this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        this.removeExpired();
        int size = this.map.size();
        for (T element : this.map.keySet()) {
            if (collection.contains(element)) continue;
            this.map.remove(element);
        }
        return size != this.map.size();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        this.removeExpired();
        return this.map.keySet().iterator();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        this.removeExpired();
        return this.map.keySet().toArray();
    }

    @Override
    @NotNull
    public <U> @NotNull U @NotNull [] toArray(@NotNull @NotNull U @NotNull [] array) {
        this.removeExpired();
        return this.map.keySet().toArray(array);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

