/*
 * Decompiled with CFR 0.152.
 */
package cc.neckbeard.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UuidConverter {
    private static final String FORMAT = "$1-$2-$3-$4-$5";
    private static final Pattern PATTERN = Pattern.compile("([0-9a-fA-F]{8})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{4})-?([0-9a-fA-F]{12})");

    @Nullable
    public static UUID of(@NotNull String string) {
        if (!PATTERN.matcher(string).matches()) {
            return null;
        }
        try {
            return UUID.fromString(string.replaceFirst(PATTERN.toString(), FORMAT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NotNull
    public static Set<String> stringify(@NotNull Set<UUID> uuids) {
        HashSet<String> set = new HashSet<String>();
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            set.add(uuid.toString());
        }
        return set;
    }

    @NotNull
    public static Set<String> stringify(@NotNull Collection<UUID> uuids) {
        return UuidConverter.stringify(uuids);
    }
}

