/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.util.Async;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;

public class ExpertAdvisorClient
extends MetaApiClient {
    public ExpertAdvisorClient(HttpClient httpClient, String token) {
        super(httpClient, token);
    }

    public ExpertAdvisorClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
    }

    public CompletableFuture<List<ExpertAdvisorDto>> getExpertAdvisors(String accountId) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getExpertAdvisors");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/expert-advisors", HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, ExpertAdvisorDto[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<ExpertAdvisorDto> getExpertAdvisor(String accountId, String expertId) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getExpertAdvisor");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/expert-advisors/" + expertId, HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, ExpertAdvisorDto.class);
    }

    public CompletableFuture<Void> updateExpertAdvisor(String accountId, String expertId, NewExpertAdvisorDto expert) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("updateExpertAdvisor");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/expert-advisors/" + expertId, HttpRequestOptions.Method.PUT);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody((Object)expert);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> uploadExpertAdvisorFile(String accountId, String expertId, String filePath) {
        return Async.run(() -> {
            try {
                this.uploadExpertAdvisorFile(accountId, expertId, new HttpRequestOptions.FileStreamField(new File(filePath))).join();
            }
            catch (FileNotFoundException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> uploadExpertAdvisorFile(String accountId, String expertId, InputStream fileContents) {
        return this.uploadExpertAdvisorFile(accountId, expertId, new HttpRequestOptions.FileStreamField(fileContents, "file"));
    }

    private CompletableFuture<Void> uploadExpertAdvisorFile(String accountId, String expertId, HttpRequestOptions.FileStreamField file) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("uploadExpertAdvisorFile");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/expert-advisors/" + expertId + "/file", HttpRequestOptions.Method.PUT);
        ConcurrentHashMap<String, HttpRequestOptions.FileStreamField> formData = new ConcurrentHashMap<String, HttpRequestOptions.FileStreamField>();
        formData.put("file", file);
        opts.setBody(formData);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> deleteExpertAdvisor(String accountId, String expertId) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("deleteExpertAdvisor");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + accountId + "/expert-advisors/" + expertId, HttpRequestOptions.Method.DELETE);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public static class NewExpertAdvisorDto {
        public String period;
        public String symbol;
        public String preset;
    }

    public static class ExpertAdvisorDto {
        public String expertId;
        public String period;
        public String symbol;
        public boolean fileUploaded;
    }
}

