/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.OptionsValidator;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.InternalException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.error_handler.TooManyRequestsException;
import cloud.metaapi.sdk.clients.error_handler.UnauthorizedException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.LatencyListener;
import cloud.metaapi.sdk.clients.meta_api.NotConnectedException;
import cloud.metaapi.sdk.clients.meta_api.NotSynchronizedException;
import cloud.metaapi.sdk.clients.meta_api.OutOfOrderListener;
import cloud.metaapi.sdk.clients.meta_api.PacketLogger;
import cloud.metaapi.sdk.clients.meta_api.PacketOrderer;
import cloud.metaapi.sdk.clients.meta_api.ReconnectListener;
import cloud.metaapi.sdk.clients.meta_api.SubscriptionManager;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationThrottler;
import cloud.metaapi.sdk.clients.meta_api.TradeException;
import cloud.metaapi.sdk.clients.meta_api.models.MarketDataSubscription;
import cloud.metaapi.sdk.clients.meta_api.models.MarketDataUnsubscription;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderBook;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderCandle;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeals;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderHistoryOrders;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTick;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTrade;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTradeResponse;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.clients.models.WebsocketError;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.Js;
import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.engineio.client.Transport;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class MetaApiWebsocketClient
implements OutOfOrderListener {
    private static Logger logger = LogManager.getLogger(MetaApiWebsocketClient.class);
    protected static int resetDisconnectTimerTimeout = 60000;
    private String domain;
    private String region;
    private String hostname;
    private String url;
    private String token;
    private String application;
    private long requestTimeout;
    private long connectTimeout;
    private int retries;
    private int minRetryDelayInSeconds;
    private int maxRetryDelayInSeconds;
    private int maxAccountsPerInstance = 100;
    private long subscribeCooldownInSeconds;
    private boolean sequentialEventProcessing;
    private boolean useSharedClientApi;
    private HttpClient httpClient;
    private ObjectMapper jsonMapper = JsonMapper.getInstance();
    private Map<String, List<SynchronizationListener>> synchronizationListeners = new ConcurrentHashMap<String, List<SynchronizationListener>>();
    private List<LatencyListener> latencyListeners = new LinkedList<LatencyListener>();
    private List<ReconnectListenerItem> reconnectListeners = new LinkedList<ReconnectListenerItem>();
    private Map<String, String> connectedHosts = new ConcurrentHashMap<String, String>();
    protected List<SocketInstance> socketInstances = new ArrayList<SocketInstance>();
    protected Map<String, Integer> socketInstancesByAccounts = new ConcurrentHashMap<String, Integer>();
    private SynchronizationThrottler.Options synchronizationThrottlerOpts;
    private SubscriptionManager subscriptionManager;
    private Map<String, Timer> statusTimers = new ConcurrentHashMap<String, Timer>();
    private Map<String, List<Supplier<CompletableFuture<Void>>>> eventQueues = new ConcurrentHashMap<String, List<Supplier<CompletableFuture<Void>>>>();
    private SubscribeLock subscribeLock;
    private PacketOrderer packetOrderer;
    private PacketLogger packetLogger;

    public MetaApiWebsocketClient(HttpClient httpClient, String token, ClientOptions opts) throws IOException, ValidationException {
        OptionsValidator validator = new OptionsValidator();
        validator.validateNonZeroInt(opts.packetOrderingTimeout, "packetOrderingTimeout");
        validator.validateNonZeroLong(opts.requestTimeout, "requestTimeout");
        validator.validateNonZeroLong(opts.connectTimeout, "requestTimeout");
        validator.validateNonZeroInt(opts.retryOpts.minDelayInSeconds, "retryOpts.minDelayInSeconds");
        validator.validateNonZeroInt(opts.retryOpts.maxDelayInSeconds, "retryOpts.maxDelayInSeconds");
        validator.validateNonZeroLong(opts.retryOpts.subscribeCooldownInSeconds, "retryOpts.subscribeCooldownInSeconds");
        this.httpClient = httpClient;
        this.application = opts.application;
        this.domain = opts.domain;
        this.region = opts.region;
        this.hostname = "mt-client-api-v1";
        this.url = "https://" + this.hostname + "." + this.domain;
        this.token = token;
        this.requestTimeout = opts.requestTimeout;
        this.connectTimeout = opts.connectTimeout;
        this.retries = opts.retryOpts.retries;
        this.minRetryDelayInSeconds = opts.retryOpts.minDelayInSeconds;
        this.maxRetryDelayInSeconds = opts.retryOpts.maxDelayInSeconds;
        this.subscribeCooldownInSeconds = opts.retryOpts.subscribeCooldownInSeconds;
        this.sequentialEventProcessing = opts.eventProcessing.sequentialProcessing;
        this.useSharedClientApi = opts.useSharedClientApi;
        this.synchronizationThrottlerOpts = opts.synchronizationThrottler;
        this.subscriptionManager = new SubscriptionManager(this);
        this.packetOrderer = new PacketOrderer(this, opts.packetOrderingTimeout);
        if (opts.packetLogger.enabled) {
            this.packetLogger = new PacketLogger(opts.packetLogger);
            this.packetLogger.start();
        }
    }

    @Override
    public void onOutOfOrderPacket(String accountId, int instanceIndex, long expectedSequenceNumber, long actualSequenceNumber, JsonNode packet, IsoTime receivedAt) {
        logger.error("MetaApi websocket client received an out of order packet type " + packet.get("type").asText() + " for account id " + accountId + ":" + instanceIndex + ". Expected s/n " + expectedSequenceNumber + " does not match the actual of " + actualSequenceNumber);
        this.ensureSubscribe(accountId, instanceIndex);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<SocketInstance> getSocketInstances() {
        return this.socketInstances;
    }

    public Map<String, Integer> getSocketInstancesByAccounts() {
        return this.socketInstancesByAccounts;
    }

    public List<String> getSubscribedAccountIds() {
        return this.getSubscribedAccountIds(null);
    }

    public List<String> getSubscribedAccountIds(Integer socketInstanceIndex) {
        ArrayList<String> connectedIds = new ArrayList<String>();
        for (String instanceId : new ArrayList<String>(this.connectedHosts.keySet())) {
            String accountId = instanceId.split(":")[0];
            if (connectedIds.contains(accountId) || !this.socketInstancesByAccounts.containsKey(accountId) || this.socketInstancesByAccounts.get(accountId) != socketInstanceIndex && socketInstanceIndex != null) continue;
            connectedIds.add(accountId);
        }
        return connectedIds;
    }

    public boolean isConnected(Integer socketInstanceIndex) {
        SocketInstance instance;
        SocketInstance socketInstance = instance = socketInstanceIndex != null && this.socketInstances.size() > socketInstanceIndex ? this.socketInstances.get(socketInstanceIndex) : null;
        return instance != null && instance.socket != null && instance.socket.connected();
    }

    public List<String> getAssignedAccounts(int socketInstanceIndex) {
        ArrayList<String> accountIds = new ArrayList<String>();
        this.socketInstancesByAccounts.keySet().stream().forEach(key -> {
            if (this.socketInstancesByAccounts.get(key) == socketInstanceIndex) {
                accountIds.add((String)key);
            }
        });
        return accountIds;
    }

    public CompletableFuture<Void> lockSocketInstance(int socketInstanceIndex, final TooManyRequestsException.TooManyRequestsExceptionMetadata metadata) {
        if (metadata.type.equals("LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_USER")) {
            this.subscribeLock = new SubscribeLock(){
                {
                    this.recommendedRetryTime = metadata.recommendedRetryTime;
                    this.lockedAtAccounts = MetaApiWebsocketClient.this.getSubscribedAccountIds().size();
                    this.lockedAtTime = Date.from(Instant.now()).getTime();
                }
            };
            return CompletableFuture.completedFuture(null);
        }
        final List<String> subscribedAccounts = this.getSubscribedAccountIds(socketInstanceIndex);
        if (subscribedAccounts.size() == 0) {
            SocketInstance socketInstance = this.socketInstances.get(socketInstanceIndex);
            socketInstance.socket.close();
            return this.reconnect(String.valueOf(socketInstanceIndex));
        }
        SocketInstance instance = this.socketInstances.get(socketInstanceIndex);
        instance.subscribeLock = new SubscribeLock(){
            {
                this.recommendedRetryTime = metadata.recommendedRetryTime;
                this.type = metadata.type;
                this.lockedAtAccounts = subscribedAccounts.size();
            }
        };
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> connect() {
        return Async.supply(() -> {
            final CompletableFuture<Void> result = new CompletableFuture<Void>();
            try {
                final int socketInstanceIndex = this.socketInstances.size();
                String serverUrl = this.getServerUrl();
                final MetaApiWebsocketClient self = this;
                SocketInstance instance = new SocketInstance(){
                    {
                        this.id = socketInstanceIndex;
                        this.connected = false;
                        this.requestResolves = new ConcurrentHashMap();
                        this.resolved = false;
                        this.connectResult = result;
                        this.sessionId = RandomStringUtils.randomAlphanumeric((int)32);
                        this.isReconnecting = false;
                        this.socket = null;
                        this.synchronizationThrottler = new SynchronizationThrottler(self, socketInstanceIndex, MetaApiWebsocketClient.this.synchronizationThrottlerOpts);
                        this.subscribeLock = null;
                        this.clientId = Math.random();
                    }
                };
                instance.connected = true;
                this.socketInstances.add(instance);
                instance.synchronizationThrottler.start();
                instance.firstConnect = true;
                this.createSocket(instance, serverUrl, result);
                Socket socketInstance = instance.socket;
                if (this.socketInstances.size() == 1) {
                    this.packetOrderer.start();
                }
                socketInstance.connect();
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return (Void)result.join();
        });
    }

    private void createSocket(SocketInstance instance, String uri, CompletableFuture<Void> result) throws URISyntaxException {
        IO.Options socketOptions = new IO.Options();
        socketOptions.path = "/ws";
        socketOptions.reconnection = true;
        socketOptions.reconnectionDelay = 1000L;
        socketOptions.reconnectionDelayMax = 5000L;
        socketOptions.reconnectionAttempts = Integer.MAX_VALUE;
        socketOptions.timeout = this.connectTimeout;
        socketOptions.transports = new String[]{"websocket"};
        Socket socketInstance = instance.socket = IO.socket((String)uri, (IO.Options)socketOptions);
        socketInstance.io().on("transport", socketEventArgs -> {
            Transport transport = (Transport)socketEventArgs[0];
            transport.query.put("auth-token", this.token);
            transport.query.put("clientId", String.valueOf(instance.clientId));
            transport.query.put("protocol", "2");
            transport.on("requestHeaders", transportEventArgs -> {
                Map headers = (Map)transportEventArgs[0];
                headers.put("Client-Id", Arrays.asList(String.valueOf(instance.clientId)));
            });
        });
        socketInstance.on("connect", args -> Async.run(() -> {
            boolean isSharedClientApi = uri.equals(this.url);
            logger.info("MetaApi websocket client connected to the MetaApi server via " + uri + " " + (isSharedClientApi ? "shared" : "dedicated") + " server");
            if (instance.id == 0 && instance.firstConnect != null && instance.firstConnect.booleanValue() && !isSharedClientApi) {
                logger.info("Please note that it can take up to 3 minutes for your dedicated server to start for the first time. During this time it is OK if you see some connection errors.");
                instance.firstConnect = false;
            }
            instance.isReconnecting = false;
            if (result != null && !result.isDone()) {
                result.complete(null);
            } else {
                ((CompletableFuture)this.fireReconnected(instance.id).exceptionally(e -> {
                    logger.error("Failed to notify reconnect listeners", e);
                    return null;
                })).join();
            }
            if (!instance.connected) {
                instance.socket.close();
            }
        }));
        socketInstance.on("reconnect", args -> {
            try {
                instance.isReconnecting = false;
                this.fireReconnected(instance.id);
            }
            catch (Exception e) {
                logger.error("Failed to notify reconnect listeners", (Throwable)e);
            }
        });
        socketInstance.on("connect_error", args -> {
            Exception error = (Exception)args[0];
            logger.error("MetaApi websocket client connection error", (Throwable)error);
            instance.isReconnecting = false;
            if (result != null && !result.isDone()) {
                result.completeExceptionally(error);
            }
        });
        socketInstance.on("connect_timeout", args -> {
            logger.info("MetaApi websocket client connection timeout");
            instance.isReconnecting = false;
            if (result != null && !result.isDone()) {
                result.completeExceptionally((Throwable)new TimeoutException("MetaApi websocket client connection timed out"));
            }
        });
        socketInstance.on("disconnect", args -> {
            instance.synchronizationThrottler.onDisconnect();
            String reason = (String)args[0];
            logger.info("MetaApi websocket client disconnected from the MetaApi server because of " + reason);
            instance.isReconnecting = false;
            try {
                this.reconnect(instance.id);
            }
            catch (Exception e) {
                logger.error("MetaApi websocket reconnect error", (Throwable)e);
            }
        });
        socketInstance.on("error", args -> {
            Exception error = (Exception)args[0];
            logger.error("MetaApi websocket client error", (Throwable)error);
            instance.isReconnecting = false;
            try {
                this.reconnect(instance.id);
            }
            catch (Exception e) {
                logger.error("MetaApi websocket reconnect error ", (Throwable)e);
            }
        });
        socketInstance.on("response", args -> {
            try {
                JsonNode data;
                RequestResolve requestResolve;
                JsonNode uncheckedData = this.jsonMapper.readTree(args[0].toString());
                if (uncheckedData.isTextual()) {
                    uncheckedData = this.jsonMapper.readTree(uncheckedData.asText());
                }
                RequestResolve requestResolve2 = requestResolve = (data = uncheckedData).has("requestId") ? instance.requestResolves.remove(data.get("requestId").asText()) : null;
                if (requestResolve != null) {
                    Async.run(() -> {
                        requestResolve.future.complete(data);
                        if (data.has("timestamps") && requestResolve.type != null) {
                            for (LatencyListener listener : this.latencyListeners) {
                                Async.run(() -> {
                                    try {
                                        String accountId = data.get("accountId").asText();
                                        if (requestResolve.type.equals("trade")) {
                                            LatencyListener.TradeTimestamps timestamps = (LatencyListener.TradeTimestamps)this.jsonMapper.treeToValue((TreeNode)data.get("timestamps"), LatencyListener.TradeTimestamps.class);
                                            timestamps.clientProcessingFinished = new IsoTime();
                                            listener.onTrade(accountId, timestamps).join();
                                        } else {
                                            LatencyListener.ResponseTimestamps timestamps = (LatencyListener.ResponseTimestamps)this.jsonMapper.treeToValue((TreeNode)data.get("timestamps"), LatencyListener.ResponseTimestamps.class);
                                            timestamps.clientProcessingFinished = new IsoTime();
                                            listener.onResponse(accountId, requestResolve.type, timestamps).join();
                                        }
                                    }
                                    catch (Throwable err) {
                                        throw new CompletionException(err);
                                    }
                                }).exceptionally(err -> {
                                    logger.error("Failed to process onResponse event for account " + data.get("accountId").toString() + ", request type" + requestResolve.type, err);
                                    return null;
                                });
                            }
                        }
                    });
                }
            }
            catch (JsonProcessingException e) {
                logger.error("MetaApi websocket parse json response error", (Throwable)e);
            }
        });
        socketInstance.on("processingError", args -> {
            try {
                WebsocketError error = (WebsocketError)((Object)((Object)this.jsonMapper.readValue(args[0].toString(), WebsocketError.class)));
                RequestResolve requestResolve = instance.requestResolves.remove(error.requestId);
                if (requestResolve != null) {
                    requestResolve.future.completeExceptionally(this.convertError(error));
                }
            }
            catch (Exception e) {
                logger.error("MetaApi websocket parse processingError data error", (Throwable)e);
            }
        });
        socketInstance.on("synchronization", args -> {
            try {
                String synchronizationId;
                ObjectNode packet = (ObjectNode)this.jsonMapper.readTree(args[0].toString());
                if (packet.isTextual()) {
                    packet = (ObjectNode)this.jsonMapper.readTree(packet.asText());
                }
                String string = synchronizationId = packet.has("synchronizationId") ? packet.get("synchronizationId").asText() : null;
                if (synchronizationId == null || instance.synchronizationThrottler.getActiveSynchronizationIds().contains(synchronizationId)) {
                    if (this.packetLogger != null) {
                        this.packetLogger.logPacket((JsonNode)packet);
                    }
                } else {
                    packet.put("type", "noop");
                }
                this.queuePacket((JsonNode)packet);
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to parse incoming synchronization packet", (Throwable)e);
            }
        });
    }

    public void close() {
        this.socketInstances.forEach(instance -> {
            if (instance.connected) {
                instance.socket.close();
                for (RequestResolve resolve : new ArrayList<RequestResolve>(instance.requestResolves.values())) {
                    resolve.future.completeExceptionally(new Exception("MetaApi connection closed"));
                }
                instance.requestResolves.clear();
            }
        });
        this.synchronizationListeners.clear();
        this.latencyListeners.clear();
        this.socketInstancesByAccounts.clear();
        this.socketInstances.clear();
        this.packetOrderer.stop();
    }

    public CompletableFuture<MetatraderAccountInformation> getAccountInformation(String accountId) {
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getAccountInformation");
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)response.get("accountInformation"), MetatraderAccountInformation.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<MetatraderPosition>> getPositions(String accountId) {
        CompletableFuture<List<MetatraderPosition>> result = new CompletableFuture<List<MetatraderPosition>>();
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getPositions");
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete(Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("positions"), MetatraderPosition[].class)));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderPosition> getPosition(String accountId, String positionId) {
        ObjectNode request = JsonMapper.getInstance().createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getPosition");
        request.put("positionId", positionId);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderPosition)this.jsonMapper.treeToValue((TreeNode)response.get("position"), MetatraderPosition.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<MetatraderOrder>> getOrders(String accountId) {
        CompletableFuture<List<MetatraderOrder>> result = new CompletableFuture<List<MetatraderOrder>>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getOrders");
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete(Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("orders"), MetatraderOrder[].class)));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderOrder> getOrder(String accountId, String orderId) {
        CompletableFuture<MetatraderOrder> result = new CompletableFuture<MetatraderOrder>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getOrder");
        request.put("orderId", orderId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                return result.complete((MetatraderOrder)this.jsonMapper.treeToValue((TreeNode)response.get("order"), MetatraderOrder.class));
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTicket(String accountId, String ticket) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getHistoryOrdersByTicket");
        request.put("ticket", ticket);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByPosition(String accountId, String positionId) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getHistoryOrdersByPosition");
        request.put("positionId", positionId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTimeRange(String accountId, IsoTime startTime, IsoTime endTime, int offset, int limit) {
        CompletableFuture<MetatraderHistoryOrders> result = new CompletableFuture<MetatraderHistoryOrders>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getHistoryOrdersByTimeRange");
        request.put("startTime", startTime.getIsoString());
        request.put("endTime", endTime.getIsoString());
        request.put("offset", offset);
        request.put("limit", limit);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderHistoryOrders history = new MetatraderHistoryOrders();
                history.historyOrders = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("historyOrders"), MetatraderOrder[].class));
                history.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(history);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByTicket(String accountId, String ticket) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getDealsByTicket");
        request.put("ticket", ticket);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByPosition(String accountId, String positionId) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getDealsByPosition");
        request.put("positionId", positionId);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetatraderDeals> getDealsByTimeRange(String accountId, IsoTime startTime, IsoTime endTime, int offset, int limit) {
        CompletableFuture<MetatraderDeals> result = new CompletableFuture<MetatraderDeals>();
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getDealsByTimeRange");
        request.put("startTime", startTime.getIsoString());
        request.put("endTime", endTime.getIsoString());
        request.put("offset", offset);
        request.put("limit", limit);
        this.rpcRequest(accountId, request).handle((response, error) -> {
            if (error != null) {
                return result.completeExceptionally((Throwable)error);
            }
            try {
                MetatraderDeals deals = new MetatraderDeals();
                deals.deals = Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("deals"), MetatraderDeal[].class));
                deals.synchronizing = response.get("synchronizing").asBoolean();
                return result.complete(deals);
            }
            catch (JsonProcessingException e) {
                return result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> removeHistory(String accountId) {
        return this.removeHistory(accountId, null);
    }

    public CompletableFuture<Void> removeHistory(String accountId, String application) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        if (application != null) {
            request.put("application", application);
        }
        request.put("type", "removeHistory");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> removeApplication(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "removeApplication");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<MetatraderTradeResponse> trade(String accountId, MetatraderTrade trade) {
        return Async.supply(() -> {
            ObjectNode request = this.jsonMapper.createObjectNode();
            request.put("type", "trade");
            request.set("trade", this.jsonMapper.valueToTree((Object)trade));
            return (MetatraderTradeResponse)((CompletableFuture)this.rpcRequest(accountId, request).thenApply(response -> {
                try {
                    MetatraderTradeResponse tradeResponse = (MetatraderTradeResponse)this.jsonMapper.treeToValue((TreeNode)response.get("response"), MetatraderTradeResponse.class);
                    if (Arrays.asList("ERR_NO_ERROR", "TRADE_RETCODE_PLACED", "TRADE_RETCODE_DONE", "TRADE_RETCODE_DONE_PARTIAL", "TRADE_RETCODE_NO_CHANGES").contains(tradeResponse.stringCode)) {
                        return tradeResponse;
                    }
                    throw new TradeException(tradeResponse.message, tradeResponse.numericCode, tradeResponse.stringCode);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            })).join();
        });
    }

    public CompletableFuture<Void> ensureSubscribe(String accountId, Integer instanceNumber) {
        return this.subscriptionManager.subscribe(accountId, instanceNumber, false);
    }

    public CompletableFuture<Void> subscribe(String accountId) {
        return this.subscribe(accountId, null);
    }

    public CompletableFuture<Void> subscribe(String accountId, Integer instanceNumber) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "subscribe");
        if (instanceNumber != null) {
            request.put("instanceIndex", instanceNumber);
        }
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> reconnect(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "reconnect");
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Boolean> synchronize(String accountId, Integer instanceIndex, String host, String synchronizationId, IsoTime startingHistoryOrderTime, IsoTime startingDealTime) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("requestId", synchronizationId);
        request.put("type", "synchronize");
        if (startingHistoryOrderTime != null) {
            request.put("startingHistoryOrderTime", startingHistoryOrderTime.getIsoString());
        }
        if (startingDealTime != null) {
            request.put("startingDealTime", startingDealTime.getIsoString());
        }
        request.put("instanceIndex", instanceIndex);
        request.put("host", host);
        SynchronizationThrottler syncThrottler = this.socketInstances.get((int)this.socketInstancesByAccounts.get((Object)accountId).intValue()).synchronizationThrottler;
        return syncThrottler.scheduleSynchronize(accountId, request);
    }

    public CompletableFuture<Void> waitSynchronized(String accountId, Integer instanceNumber, String applicationPattern, Long timeoutInSeconds) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "waitSynchronized");
        if (applicationPattern != null) {
            request.put("applicationPattern", applicationPattern);
        }
        request.put("timeoutInSeconds", timeoutInSeconds);
        request.put("instanceIndex", instanceNumber);
        return this.rpcRequest(accountId, request, timeoutInSeconds + 1L).thenApply(response -> null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String accountId, Integer instanceNumber, String symbol, List<MarketDataSubscription> subscriptions) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "subscribeToMarketData");
        request.put("symbol", symbol);
        request.set("subscriptions", this.jsonMapper.valueToTree(subscriptions));
        request.put("instanceIndex", instanceNumber);
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<Void> unsubscribeFromMarketData(String accountId, int instanceNumber, String symbol, List<MarketDataUnsubscription> subscriptions) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "unsubscribeFromMarketData");
        request.put("symbol", symbol);
        request.set("subscriptions", this.jsonMapper.valueToTree(subscriptions));
        request.put("instanceIndex", instanceNumber);
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<List<String>> getSymbols(String accountId) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getSymbols");
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)response.get("symbols"), String[].class));
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<MetatraderSymbolSpecification> getSymbolSpecification(String accountId, String symbol) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getSymbolSpecification");
        request.put("symbol", symbol);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderSymbolSpecification)this.jsonMapper.treeToValue((TreeNode)response.get("specification"), MetatraderSymbolSpecification.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<MetatraderSymbolPrice> getSymbolPrice(String accountId, String symbol) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getSymbolPrice");
        request.put("symbol", symbol);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderSymbolPrice)this.jsonMapper.treeToValue((TreeNode)response.get("price"), MetatraderSymbolPrice.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<MetatraderCandle> getCandle(String accountId, String symbol, String timeframe) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getCandle");
        request.put("symbol", symbol);
        request.put("timeframe", timeframe);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderCandle)this.jsonMapper.treeToValue((TreeNode)response.get("candle"), MetatraderCandle.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<MetatraderTick> getTick(String accountId, String symbol) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getTick");
        request.put("symbol", symbol);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderTick)this.jsonMapper.treeToValue((TreeNode)response.get("tick"), MetatraderTick.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<MetatraderBook> getBook(String accountId, String symbol) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("application", "RPC");
        request.put("type", "getBook");
        request.put("symbol", symbol);
        return this.rpcRequest(accountId, request).thenApply(response -> {
            try {
                return (MetatraderBook)this.jsonMapper.treeToValue((TreeNode)response.get("book"), MetatraderBook.class);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> saveUptime(String accountId, Map<String, Double> uptime) {
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "saveUptime");
        request.set("uptime", this.jsonMapper.valueToTree(uptime));
        return this.rpcRequest(accountId, request).thenApply(response -> null);
    }

    public CompletableFuture<JsonNode> unsubscribe(String accountId) {
        this.subscriptionManager.cancelAccount(accountId);
        ObjectNode request = this.jsonMapper.createObjectNode();
        request.put("type", "unsubscribe");
        return this.rpcRequest(accountId, request).handle((response, err) -> {
            if (err != null && !(err.getCause() instanceof NotFoundException)) {
                throw new CompletionException((Throwable)err);
            }
            this.socketInstancesByAccounts.remove(accountId);
            return response;
        });
    }

    public void addSynchronizationListener(String accountId, SynchronizationListener listener) {
        List<SynchronizationListener> listeners = this.synchronizationListeners.get(accountId);
        if (listeners == null) {
            listeners = new LinkedList<SynchronizationListener>();
            this.synchronizationListeners.put(accountId, listeners);
        }
        listeners.add(listener);
    }

    public void removeSynchronizationListener(String accountId, SynchronizationListener listener) {
        List<SynchronizationListener> listeners = this.synchronizationListeners.get(accountId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void addLatencyListener(LatencyListener listener) {
        this.latencyListeners.add(listener);
    }

    public void removeLatencyListener(LatencyListener listener) {
        this.latencyListeners.remove(listener);
    }

    public void addReconnectListener(ReconnectListener listener, String accountId) {
        final String aid = accountId;
        final ReconnectListener l = listener;
        this.reconnectListeners.add(new ReconnectListenerItem(){
            {
                this.accountId = aid;
                this.listener = l;
            }
        });
    }

    public void removeReconnectListener(ReconnectListener listener) {
        this.reconnectListeners.removeIf(item -> item.listener == listener);
    }

    public void removeAllListeners() {
        this.synchronizationListeners.clear();
        this.reconnectListeners.clear();
    }

    public void queuePacket(JsonNode packet) {
        String accountId = packet.get("accountId").asText();
        List<JsonNode> packets = this.packetOrderer.restoreOrder(packet).stream().filter(p -> !p.get("type").asText().equals("noop")).collect(Collectors.toList());
        if (this.sequentialEventProcessing && packet.has("sequenceNumber")) {
            List events = packets.stream().map(packetItem -> new Supplier<CompletableFuture<Void>>(){

                @Override
                public CompletableFuture<Void> get() {
                    return MetaApiWebsocketClient.this.processSynchronizationPacket(packetItem);
                }
            }).collect(Collectors.toList());
            if (!this.eventQueues.containsKey(accountId)) {
                this.eventQueues.put(accountId, new ArrayList(events));
                this.callAccountEvents(accountId);
            } else {
                this.eventQueues.get(accountId).addAll(events);
            }
        } else {
            packets.forEach(packetItem -> this.processSynchronizationPacket((JsonNode)packetItem));
        }
    }

    public void queueEvent(String accountId, Supplier<CompletableFuture<Void>> event) {
        if (this.sequentialEventProcessing) {
            if (!this.eventQueues.containsKey(accountId)) {
                ArrayList<Supplier<CompletableFuture<Void>>> events = new ArrayList<Supplier<CompletableFuture<Void>>>();
                events.add(event);
                this.eventQueues.put(accountId, events);
                this.callAccountEvents(accountId);
            } else {
                this.eventQueues.get(accountId).add(event);
            }
        } else {
            event.get();
        }
    }

    private CompletableFuture<Void> callAccountEvents(String accountId) {
        return Async.run(() -> {
            if (this.eventQueues.containsKey(accountId)) {
                while (this.eventQueues.get(accountId).size() > 0) {
                    this.eventQueues.get(accountId).get(0).get().join();
                    this.eventQueues.get(accountId).remove(0);
                }
                this.eventQueues.remove(accountId);
            }
        });
    }

    private CompletableFuture<Void> reconnect(int socketInstanceIndex) {
        return Async.run(() -> {
            try {
                if (this.socketInstances.size() > socketInstanceIndex) {
                    SocketInstance instance = this.socketInstances.get(socketInstanceIndex);
                    while (!instance.socket.connected() && !instance.isReconnecting && instance.connected) {
                        this.tryReconnect(socketInstanceIndex);
                    }
                }
            }
            catch (Throwable err) {
                throw new CompletionException(err);
            }
        });
    }

    private void tryReconnect(int socketInstanceIndex) throws Exception {
        SocketInstance instance = this.socketInstances.get(socketInstanceIndex);
        Thread.sleep(1000L);
        if (!instance.socket.connected() && !instance.isReconnecting && instance.connected) {
            instance.sessionId = RandomStringUtils.randomAlphanumeric((int)32);
            instance.socket.close();
            instance.clientId = Math.random();
            instance.isReconnecting = true;
            this.createSocket(instance, this.getServerUrl(), null);
            instance.socket.connect();
        }
    }

    private CompletableFuture<JsonNode> rpcRequest(String accountId, ObjectNode request) {
        return this.rpcRequest(accountId, request, null);
    }

    protected CompletableFuture<JsonNode> rpcRequest(String accountId, ObjectNode request, Long timeoutInSeconds) {
        return Async.supply(() -> {
            try {
                Integer socketInstanceIndex = null;
                if (this.socketInstancesByAccounts.containsKey(accountId)) {
                    socketInstanceIndex = this.socketInstancesByAccounts.get(accountId);
                } else {
                    while (this.subscribeLock != null && (this.subscribeLock.recommendedRetryTime.getDate().getTime() > Date.from(Instant.now()).getTime() && this.getSubscribedAccountIds().size() < this.subscribeLock.lockedAtAccounts || this.subscribeLock.lockedAtTime + this.subscribeCooldownInSeconds * 1000L > Date.from(Instant.now()).getTime() && this.getSubscribedAccountIds().size() >= this.subscribeLock.lockedAtAccounts)) {
                        Thread.sleep(1000L);
                    }
                    for (int index = 0; index < this.socketInstances.size(); ++index) {
                        int accountCounter = this.getAssignedAccounts(index).size();
                        SocketInstance instance = this.socketInstances.get(index);
                        if (instance.subscribeLock != null && (instance.subscribeLock.type.equals("LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_USER_PER_SERVER") && (instance.subscribeLock.recommendedRetryTime.getDate().getTime() > Date.from(Instant.now()).getTime() || this.getSubscribedAccountIds(index).size() >= instance.subscribeLock.lockedAtAccounts) || instance.subscribeLock.type.equals("LIMIT_ACCOUNT_SUBSCRIPTIONS_PER_SERVER") && instance.subscribeLock.recommendedRetryTime.getDate().getTime() > Date.from(Instant.now()).getTime() && this.getSubscribedAccountIds(index).size() >= instance.subscribeLock.lockedAtAccounts) || accountCounter >= this.maxAccountsPerInstance) continue;
                        socketInstanceIndex = index;
                        break;
                    }
                    if (socketInstanceIndex == null) {
                        socketInstanceIndex = this.socketInstances.size();
                        this.connect().join();
                    }
                    this.socketInstancesByAccounts.put(accountId, socketInstanceIndex);
                }
                SocketInstance instance = this.socketInstances.get(socketInstanceIndex);
                if (!instance.connected) {
                    this.connect().join();
                } else if (!this.isConnected(socketInstanceIndex)) {
                    instance.connectResult.join();
                }
                if (request.get("type").asText().equals("subscribe")) {
                    request.put("sessionId", instance.sessionId);
                }
                if (Arrays.asList("trade", "subscribe").indexOf(request.get("type").asText()) != -1) {
                    return this.makeRequest(accountId, request, timeoutInSeconds);
                }
                int retryCounter = 0;
                while (true) {
                    try {
                        return this.makeRequest(accountId, request, timeoutInSeconds);
                    }
                    catch (Throwable err) {
                        if (err instanceof TooManyRequestsException) {
                            int calcRetryCounter = retryCounter;
                            int calcRequestTime = 0;
                            while (calcRetryCounter < this.retries) {
                                calcRequestTime = (int)((double)calcRequestTime + Math.min(Math.pow(2.0, ++calcRetryCounter) * (double)this.minRetryDelayInSeconds, (double)this.maxRetryDelayInSeconds) * 1000.0);
                            }
                            long retryTime = ((TooManyRequestsException)err).metadata.recommendedRetryTime.getDate().getTime();
                            if (Date.from(Instant.now()).getTime() + (long)calcRequestTime > retryTime && retryCounter < this.retries) {
                                if (Date.from(Instant.now()).getTime() < retryTime) {
                                    Thread.sleep(retryTime - Date.from(Instant.now()).getTime());
                                }
                                ++retryCounter;
                                continue;
                            }
                            throw err;
                        }
                        if (Arrays.asList(NotSynchronizedException.class, TimeoutException.class, NotConnectedException.class, InternalException.class).indexOf(err.getClass()) != -1 && retryCounter < this.retries) {
                            Thread.sleep((long)(Math.min(Math.pow(2.0, retryCounter) * (double)this.minRetryDelayInSeconds, (double)this.maxRetryDelayInSeconds) * 1000.0));
                            ++retryCounter;
                            continue;
                        }
                        throw err;
                        if (this.socketInstancesByAccounts.containsKey(accountId)) continue;
                        throw err;
                    }
                    break;
                }
            }
            catch (Throwable err) {
                throw new CompletionException(err);
            }
        });
    }

    private JsonNode makeRequest(String accountId, final ObjectNode request, Long timeoutInSeconds) throws Throwable {
        SocketInstance socketInstance = this.socketInstances.get(this.socketInstancesByAccounts.get(accountId));
        String requestId = request.has("requestId") ? request.get("requestId").asText() : UUID.randomUUID().toString();
        try {
            ObjectNode timestamps = this.jsonMapper.createObjectNode();
            timestamps.put("clientProcessingStarted", new IsoTime(Date.from(Instant.now())).toString());
            request.set("timestamps", (JsonNode)timestamps);
            RequestResolve resolve = new RequestResolve(){
                {
                    this.future = new CompletableFuture();
                    this.type = request.get("type").asText();
                }
            };
            socketInstance.requestResolves.put(requestId, resolve);
            request.put("accountId", accountId);
            if (!request.has("application")) {
                request.put("application", this.application);
            }
            if (!request.has("requestId")) {
                request.put("requestId", requestId);
            }
            socketInstance.socket.emit("request", new Object[]{new JSONObject(this.jsonMapper.writeValueAsString((Object)request))});
            if (timeoutInSeconds != null) {
                return resolve.future.get(timeoutInSeconds, TimeUnit.SECONDS);
            }
            return resolve.future.get(this.requestTimeout, TimeUnit.MILLISECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException("MetaApi websocket client request " + requestId + " of type " + request.get("type").asText() + " timed out. Please make sure your account is connected to broker before retrying your request.");
        }
        catch (JsonProcessingException | InterruptedException | JSONException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private Exception convertError(WebsocketError error) {
        switch (error.error) {
            case "ValidationError": {
                Object details = null;
                try {
                    if (error.details != null) {
                        details = JsonMapper.getInstance().treeToValue((TreeNode)error.details, Object.class);
                    }
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to parse validation error details: " + error.details, (Throwable)e);
                }
                return new ValidationException(error.message, details);
            }
            case "NotFoundError": {
                return new NotFoundException(error.message);
            }
            case "NotSynchronizedError": {
                return new NotSynchronizedException(error.message);
            }
            case "TimeoutError": {
                return new TimeoutException(error.message);
            }
            case "NotAuthenticatedError": {
                return new NotConnectedException(error.message);
            }
            case "TradeError": {
                return new TradeException(error.message, error.numericCode, error.stringCode);
            }
            case "UnauthorizedError": {
                this.close();
                return new UnauthorizedException(error.message);
            }
            case "TooManyRequestsError": {
                TooManyRequestsException.TooManyRequestsExceptionMetadata metadata = null;
                try {
                    if (error.metadata != null) {
                        metadata = (TooManyRequestsException.TooManyRequestsExceptionMetadata)JsonMapper.getInstance().treeToValue((TreeNode)error.metadata, TooManyRequestsException.TooManyRequestsExceptionMetadata.class);
                    }
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to parse too many requests error metadata: " + error.metadata, (Throwable)e);
                }
                return new TooManyRequestsException(error.message, metadata);
            }
        }
        return new InternalException(error.message);
    }

    private CompletableFuture<Void> processSynchronizationPacket(JsonNode data) {
        return Async.run(() -> {
            try {
                String synchronizationId;
                String accountId = data.get("accountId").asText();
                Integer socketInstanceIndex = this.socketInstancesByAccounts.get(accountId);
                SocketInstance socketInstance = socketInstanceIndex != null && this.socketInstances.size() > socketInstanceIndex ? this.socketInstances.get(socketInstanceIndex) : null;
                String string = synchronizationId = data.has("synchronizationId") ? data.get("synchronizationId").asText() : null;
                if (synchronizationId != null && socketInstance != null) {
                    socketInstance.synchronizationThrottler.updateSynchronizationId(synchronizationId);
                }
                int instanceNumber = data.has("instanceIndex") ? data.get("instanceIndex").asInt() : 0;
                String host = data.has("host") ? data.get("host").asText() : null;
                String instanceId = accountId + ":" + instanceNumber + ":" + Js.or((Object[])new Serializable[]{host, Integer.valueOf(0)});
                String instanceIndex = instanceNumber + ":" + Js.or((Object[])new Serializable[]{host, Integer.valueOf(0)});
                ArrayList listeners = this.synchronizationListeners.containsKey(accountId) ? this.synchronizationListeners.get(accountId) : new ArrayList();
                Supplier<Boolean> isOnlyActiveInstance = () -> {
                    List activeInstanceIds = this.connectedHosts.keySet().stream().filter(instance -> instance.startsWith(accountId + ":" + instanceNumber)).collect(Collectors.toList());
                    return activeInstanceIds.size() == 0 || activeInstanceIds.size() == 1 && ((String)activeInstanceIds.get(0)).equals(instanceId);
                };
                Function<Boolean, CompletableFuture> onDisconnected = isTimeout -> Async.run(() -> this.lambda$null$58(instanceId, (Supplier)isOnlyActiveInstance, isTimeout, accountId, instanceNumber, listeners, instanceIndex, socketInstance, host));
                Runnable cancelDisconnectTimer = () -> {
                    if (this.statusTimers.containsKey(instanceId)) {
                        this.statusTimers.get(instanceId).cancel();
                    }
                };
                Runnable resetDisconnectTimer = () -> {
                    cancelDisconnectTimer.run();
                    this.statusTimers.put(instanceId, Js.setTimeout(() -> this.lambda$null$62((Supplier)isOnlyActiveInstance, accountId, instanceNumber, onDisconnected), (int)resetDisconnectTimerTimeout));
                };
                String type = data.get("type").asText();
                if (type.equals("authenticated")) {
                    resetDisconnectTimer.run();
                    if (!data.has("sessionId") || data.get("sessionId").asText().equals(socketInstance.sessionId)) {
                        this.connectedHosts.put(instanceId, "" + host);
                        ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener : listeners) {
                            completableFutures.add(listener.onConnected(instanceIndex, data.get("replicas").asInt()).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about connected event", e);
                                return null;
                            }));
                        }
                        this.subscriptionManager.cancelSubscribe(accountId + ":" + instanceNumber);
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                    }
                } else if (type.equals("disconnected")) {
                    cancelDisconnectTimer.run();
                    onDisconnected.apply(false).get();
                } else if (type.equals("synchronizationStarted")) {
                    ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                    for (SynchronizationListener listener : listeners) {
                        completableFutures.add(listener.onSynchronizationStarted(instanceIndex).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about synchronization started event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("accountInformation")) {
                    if (data.hasNonNull(type)) {
                        MetatraderAccountInformation accountInformation = (MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderAccountInformation.class);
                        ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener : listeners) {
                            completableFutures.add(listener.onAccountInformationUpdated(instanceIndex, accountInformation).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about accountInformation event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                    }
                } else if (type.equals("deals")) {
                    if (data.hasNonNull(type)) {
                        MetatraderDeal[] deals;
                        for (MetatraderDeal deal : deals = (MetatraderDeal[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderDeal[].class)) {
                            ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onDealAdded(instanceIndex, deal).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about deals event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                } else if (type.equals("orders")) {
                    ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                    MetatraderOrder[] orders = data.hasNonNull("orders") ? (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderOrder[].class) : new MetatraderOrder[]{};
                    for (SynchronizationListener listener : listeners) {
                        completableFutures.add(listener.onOrdersReplaced(instanceIndex, Arrays.asList(orders)).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about orders event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("historyOrders")) {
                    if (data.hasNonNull(type)) {
                        MetatraderOrder[] historyOrders;
                        for (MetatraderOrder historyOrder : historyOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderOrder[].class)) {
                            ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onHistoryOrderAdded(instanceIndex, historyOrder).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about historyOrders event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                } else if (type.equals("positions")) {
                    ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                    MetatraderPosition[] positions = data.hasNonNull("positions") ? (MetatraderPosition[])this.jsonMapper.treeToValue((TreeNode)data.get(type), MetatraderPosition[].class) : new MetatraderPosition[]{};
                    for (SynchronizationListener listener : listeners) {
                        completableFutures.add(listener.onPositionsReplaced(instanceIndex, Arrays.asList(positions)).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about positions event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("update")) {
                    ArrayList<CompletionStage> completableFutures;
                    if (data.hasNonNull("accountInformation")) {
                        MetatraderAccountInformation accountInformation = (MetatraderAccountInformation)this.jsonMapper.treeToValue((TreeNode)data.get("accountInformation"), MetatraderAccountInformation.class);
                        Object[] completableFutures2 = new ArrayList();
                        for (SynchronizationListener listener : listeners) {
                            completableFutures2.add(listener.onAccountInformationUpdated(instanceIndex, accountInformation).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(completableFutures2.toArray(new CompletableFuture[0])).get();
                    }
                    if (data.hasNonNull("updatedPositions")) {
                        MetatraderPosition[] positions = (MetatraderPosition[])this.jsonMapper.treeToValue((TreeNode)data.get("updatedPositions"), MetatraderPosition[].class);
                        for (MetatraderPosition position : positions) {
                            completableFutures = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onPositionUpdated(instanceIndex, position).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.hasNonNull("removedPositionIds")) {
                        String[] removedPositionIds = (String[])this.jsonMapper.treeToValue((TreeNode)data.get("removedPositionIds"), String[].class);
                        for (String positionId : removedPositionIds) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onPositionRemoved(instanceIndex, positionId).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.hasNonNull("updatedOrders")) {
                        MetatraderOrder[] updatedOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get("updatedOrders"), MetatraderOrder[].class);
                        for (MetatraderOrder order : updatedOrders) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onOrderUpdated(instanceIndex, order).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.hasNonNull("completedOrderIds")) {
                        String[] completedOrderIds = (String[])this.jsonMapper.treeToValue((TreeNode)data.get("completedOrderIds"), String[].class);
                        for (String orderId : completedOrderIds) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onOrderCompleted(instanceIndex, orderId).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.hasNonNull("historyOrders")) {
                        MetatraderOrder[] historyOrders = (MetatraderOrder[])this.jsonMapper.treeToValue((TreeNode)data.get("historyOrders"), MetatraderOrder[].class);
                        for (MetatraderOrder historyOrder : historyOrders) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onHistoryOrderAdded(instanceIndex, historyOrder).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.hasNonNull("deals")) {
                        MetatraderDeal[] deals = (MetatraderDeal[])this.jsonMapper.treeToValue((TreeNode)data.get("deals"), MetatraderDeal[].class);
                        for (MetatraderDeal deal : deals) {
                            completableFutures = new ArrayList();
                            for (SynchronizationListener listener : listeners) {
                                completableFutures.add(listener.onDealAdded(instanceIndex, deal).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about update event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                    if (data.has("timestamps")) {
                        LatencyListener.UpdateTimestamps timestamps = (LatencyListener.UpdateTimestamps)this.jsonMapper.treeToValue((TreeNode)data.get("timestamps"), LatencyListener.UpdateTimestamps.class);
                        timestamps.clientProcessingFinished = new IsoTime();
                        ArrayList<CompletionStage> onUpdateFutures = new ArrayList<CompletionStage>();
                        for (LatencyListener listener : this.latencyListeners) {
                            onUpdateFutures.add(listener.onUpdate(accountId, timestamps).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify latency listener about update event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onUpdateFutures.toArray(new CompletableFuture[0])).get();
                    }
                } else if (type.equals("dealSynchronizationFinished")) {
                    ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                    for (SynchronizationListener listener : listeners) {
                        if (socketInstance != null) {
                            socketInstance.synchronizationThrottler.removeSynchronizationId(synchronizationId);
                        }
                        completableFutures.add(listener.onDealSynchronizationFinished(instanceIndex, data.get("synchronizationId").asText()).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about dealSynchronizationFinished event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("orderSynchronizationFinished")) {
                    ArrayList<CompletionStage> completableFutures = new ArrayList<CompletionStage>();
                    for (SynchronizationListener listener : listeners) {
                        completableFutures.add(listener.onOrderSynchronizationFinished(instanceIndex, data.get("synchronizationId").asText()).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about orderSynchronizationFinished event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("status")) {
                    if (!this.connectedHosts.containsKey(instanceId)) {
                        if (this.statusTimers.containsKey(instanceId) && data.has("authenticated") && data.get("authenticated").asBoolean() && (this.subscriptionManager.isDisconnectedRetryMode(accountId, instanceNumber) || !this.subscriptionManager.isAccountSubscribing(accountId, instanceNumber))) {
                            this.subscriptionManager.cancelSubscribe(accountId + ":" + instanceNumber);
                            Thread.sleep(10L);
                            logger.info("It seems like we are not connected to a running API server yet, retrying subscription for account " + instanceId);
                            this.ensureSubscribe(accountId, instanceNumber);
                        }
                    } else {
                        resetDisconnectTimer.run();
                        ArrayList<CompletionStage> onBrokerConnectionStatusChangedFutures = new ArrayList<CompletionStage>();
                        for (Object listener : listeners) {
                            onBrokerConnectionStatusChangedFutures.add(((SynchronizationListener)listener).onBrokerConnectionStatusChanged(instanceIndex, data.get("connected").asBoolean()).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about brokerConnectionStatusChanged event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onBrokerConnectionStatusChangedFutures.toArray(new CompletableFuture[0])).get();
                        if (data.hasNonNull("healthStatus")) {
                            ArrayList<CompletionStage> onHealthStatusFutures = new ArrayList<CompletionStage>();
                            for (SynchronizationListener listener : listeners) {
                                onHealthStatusFutures.add(listener.onHealthStatus(instanceIndex, (SynchronizationListener.HealthStatus)this.jsonMapper.treeToValue((TreeNode)data.get("healthStatus"), SynchronizationListener.HealthStatus.class)).exceptionally(e -> {
                                    logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about server-side healthStatus event", e);
                                    return null;
                                }));
                            }
                            CompletableFuture.allOf(onHealthStatusFutures.toArray(new CompletableFuture[0])).get();
                        }
                    }
                } else if (type.equals("downgradeSubscription")) {
                    logger.info(accountId + ":" + instanceIndex + ": Market data subscriptions for symbol " + data.get("symbol") + " were downgraded by the server due to rate limits. Updated subscriptions: " + data.get("updates") + ", removed subscriptions: " + data.get("unsubscriptions") + ". Please read https://metaapi.cloud/docs/client/rateLimiting/ for more details.");
                    ArrayList<CompletionStage> onSubscriptionDowngradeFutures = new ArrayList<CompletionStage>();
                    for (SynchronizationListener listener : listeners) {
                        onSubscriptionDowngradeFutures.add(listener.onSubscriptionDowngraded(instanceIndex, data.get("symbol").asText(), data.has("updates") ? Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)data.get("updates"), MarketDataSubscription[].class)) : new ArrayList(), data.has("unsubscriptions") ? Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)data.get("unsubscriptions"), MarketDataUnsubscription[].class)) : new ArrayList<MarketDataUnsubscription>()).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about subscription downgrade event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(onSubscriptionDowngradeFutures.toArray(new CompletableFuture[0])).get();
                } else if (type.equals("specifications")) {
                    ArrayList<CompletionStage> onSymbolSpecificationsUpdatedFutures = new ArrayList<CompletionStage>();
                    ArrayList<MetatraderSymbolSpecification> specifications = data.hasNonNull("specifications") ? Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)data.get("specifications"), MetatraderSymbolSpecification[].class)) : new ArrayList<MetatraderSymbolSpecification>();
                    ArrayList<String> removedSymbols = data.hasNonNull("removedSymbols") ? Arrays.asList((Object[])this.jsonMapper.treeToValue((TreeNode)data.get("removedSymbols"), String[].class)) : new ArrayList<String>();
                    for (SynchronizationListener listener : listeners) {
                        onSymbolSpecificationsUpdatedFutures.add(listener.onSymbolSpecificationsUpdated(instanceIndex, specifications, removedSymbols).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about specifications updated event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(onSymbolSpecificationsUpdatedFutures.toArray(new CompletableFuture[0])).get();
                    for (MetatraderSymbolSpecification specification : specifications) {
                        ArrayList<CompletionStage> onSymbolSpecificationUpdatedFutures = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener : listeners) {
                            onSymbolSpecificationUpdatedFutures.add(listener.onSymbolSpecificationUpdated(instanceIndex, specification).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about specification updated event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onSymbolSpecificationUpdatedFutures.toArray(new CompletableFuture[0])).get();
                    }
                    for (String removedSymbol : removedSymbols) {
                        ArrayList<CompletionStage> onSymbolSpecificationRemovedFutures = new ArrayList<CompletionStage>();
                        for (SynchronizationListener listener : listeners) {
                            onSymbolSpecificationRemovedFutures.add(listener.onSymbolSpecificationRemoved(instanceIndex, removedSymbol).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about specifications removed event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onSymbolSpecificationRemovedFutures.toArray(new CompletableFuture[0])).get();
                    }
                } else if (type.equals("prices")) {
                    List<MetatraderSymbolPrice> prices = Arrays.asList(data.hasNonNull("prices") ? (MetatraderSymbolPrice[])this.jsonMapper.treeToValue((TreeNode)data.get("prices"), MetatraderSymbolPrice[].class) : new MetatraderSymbolPrice[]{});
                    List<MetatraderCandle> candles = Arrays.asList(data.hasNonNull("candles") ? (MetatraderCandle[])this.jsonMapper.treeToValue((TreeNode)data.get("candles"), MetatraderCandle[].class) : new MetatraderCandle[]{});
                    List<MetatraderTick> ticks = Arrays.asList(data.hasNonNull("ticks") ? (MetatraderTick[])this.jsonMapper.treeToValue((TreeNode)data.get("ticks"), MetatraderTick[].class) : new MetatraderTick[]{});
                    List<MetatraderBook> books = Arrays.asList(data.hasNonNull("books") ? (MetatraderBook[])this.jsonMapper.treeToValue((TreeNode)data.get("books"), MetatraderBook[].class) : new MetatraderBook[]{});
                    ArrayList<CompletionStage> onPricesUpdatedFutures = new ArrayList<CompletionStage>();
                    for (SynchronizationListener listener : listeners) {
                        if (prices.size() != 0) {
                            onPricesUpdatedFutures.add(listener.onSymbolPricesUpdated(instanceIndex, prices, data.has("equity") ? Double.valueOf(data.get("equity").asDouble()) : null, data.has("margin") ? Double.valueOf(data.get("margin").asDouble()) : null, data.has("freeMargin") ? Double.valueOf(data.get("freeMargin").asDouble()) : null, data.has("marginLevel") ? Double.valueOf(data.get("marginLevel").asDouble()) : null, data.has("accountCurrencyExchangeRate") ? Double.valueOf(data.get("accountCurrencyExchangeRate").asDouble()) : null).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about prices event", e);
                                return null;
                            }));
                        }
                        if (candles.size() != 0) {
                            onPricesUpdatedFutures.add(listener.onCandlesUpdated(instanceIndex, candles, data.has("equity") ? Double.valueOf(data.get("equity").asDouble()) : null, data.has("margin") ? Double.valueOf(data.get("margin").asDouble()) : null, data.has("freeMargin") ? Double.valueOf(data.get("freeMargin").asDouble()) : null, data.has("marginLevel") ? Double.valueOf(data.get("marginLevel").asDouble()) : null, data.has("accountCurrencyExchangeRate") ? Double.valueOf(data.get("accountCurrencyExchangeRate").asDouble()) : null).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about candles event", e);
                                return null;
                            }));
                        }
                        if (ticks.size() != 0) {
                            onPricesUpdatedFutures.add(listener.onTicksUpdated(instanceIndex, ticks, data.has("equity") ? Double.valueOf(data.get("equity").asDouble()) : null, data.has("margin") ? Double.valueOf(data.get("margin").asDouble()) : null, data.has("freeMargin") ? Double.valueOf(data.get("freeMargin").asDouble()) : null, data.has("marginLevel") ? Double.valueOf(data.get("marginLevel").asDouble()) : null, data.has("accountCurrencyExchangeRate") ? Double.valueOf(data.get("accountCurrencyExchangeRate").asDouble()) : null).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about ticks event", e);
                                return null;
                            }));
                        }
                        if (books.size() == 0) continue;
                        onPricesUpdatedFutures.add(listener.onBooksUpdated(instanceIndex, books, data.has("equity") ? Double.valueOf(data.get("equity").asDouble()) : null, data.has("margin") ? Double.valueOf(data.get("margin").asDouble()) : null, data.has("freeMargin") ? Double.valueOf(data.get("freeMargin").asDouble()) : null, data.has("marginLevel") ? Double.valueOf(data.get("marginLevel").asDouble()) : null, data.has("accountCurrencyExchangeRate") ? Double.valueOf(data.get("accountCurrencyExchangeRate").asDouble()) : null).exceptionally(e -> {
                            logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about books event", e);
                            return null;
                        }));
                    }
                    CompletableFuture.allOf(onPricesUpdatedFutures.toArray(new CompletableFuture[0])).get();
                    for (MetatraderSymbolPrice price : prices) {
                        ArrayList<CompletionStage> onPriceUpdatedFutures = new ArrayList<CompletionStage>();
                        for (SynchronizationListener synchronizationListener : listeners) {
                            onPriceUpdatedFutures.add(synchronizationListener.onSymbolPriceUpdated(instanceIndex, price).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about price event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onPriceUpdatedFutures.toArray(new CompletableFuture[0])).get();
                    }
                    for (MetatraderSymbolPrice price : prices) {
                        if (price.timestamps == null) continue;
                        price.timestamps.clientProcessingFinished = new IsoTime(Date.from(Instant.now()));
                        ArrayList<CompletionStage> onSymbolPriceFutures = new ArrayList<CompletionStage>();
                        for (LatencyListener latencyListener : this.latencyListeners) {
                            onSymbolPriceFutures.add(latencyListener.onSymbolPrice(accountId, price.symbol, price.timestamps).exceptionally(e -> {
                                logger.error(accountId + ":" + instanceIndex + ": Failed to notify latency listener about price event", e);
                                return null;
                            }));
                        }
                        CompletableFuture.allOf(onSymbolPriceFutures.toArray(new CompletableFuture[0])).get();
                    }
                }
            }
            catch (JsonProcessingException | InterruptedException | ExecutionException e2) {
                logger.error("Failed to process incoming synchronization packet", e2);
            }
        });
    }

    private CompletableFuture<Void> fireReconnected(int socketInstanceIndex) {
        return Async.run(() -> {
            ArrayList<ReconnectListenerItem> reconnectListeners = new ArrayList<ReconnectListenerItem>();
            for (ReconnectListenerItem listener2 : this.reconnectListeners) {
                if (this.socketInstancesByAccounts.getOrDefault(listener2.accountId, -1) != socketInstanceIndex) continue;
                reconnectListeners.add(listener2);
            }
            List<String> reconnectAccountIds = reconnectListeners.stream().map(listener -> listener.accountId).collect(Collectors.toList());
            this.subscriptionManager.onReconnected(socketInstanceIndex, reconnectAccountIds);
            this.packetOrderer.onReconnected(reconnectAccountIds);
            for (ReconnectListenerItem listener3 : reconnectListeners) {
                this.queueEvent(listener3.accountId, () -> listener.listener.onReconnected().exceptionally(err -> {
                    logger.error("[" + new IsoTime() + "] Failed to notify reconnect listener", err);
                    return null;
                }));
            }
        });
    }

    protected String getServerUrl() throws Exception {
        String url;
        boolean isDefaultRegion;
        boolean bl = isDefaultRegion = this.region == null;
        if (this.region != null) {
            HttpRequestOptions opts = new HttpRequestOptions("https://mt-provisioning-api-v1." + this.domain + "/users/current/regions", HttpRequestOptions.Method.GET);
            opts.getHeaders().put("auth-token", this.token);
            List<Object> regions = Arrays.asList((Object[])this.httpClient.requestJson(opts, String[].class).join());
            if (!regions.contains(this.region)) {
                String errorMessage = "The region \"" + this.region + "\" you are trying to connect to does not exist or is not available to you. Please specify a correct region name in the region MetaApi constructor option.";
                logger.error(errorMessage);
                throw new NotFoundException(errorMessage);
            }
            if (this.region.equals(regions.get(0))) {
                isDefaultRegion = true;
            }
        }
        if (this.useSharedClientApi) {
            url = isDefaultRegion ? this.url : "https://" + this.hostname + "." + this.region + "." + this.domain;
        } else {
            HttpRequestOptions opts = new HttpRequestOptions("https://mt-provisioning-api-v1." + this.domain + "/users/current/servers/mt-client-api", HttpRequestOptions.Method.GET);
            opts.getHeaders().put("auth-token", this.token);
            JsonNode response = this.jsonMapper.readTree((String)this.httpClient.request(opts).join());
            url = isDefaultRegion ? response.get("url").asText() : "https://" + response.get("hostname").asText() + "." + this.region + "." + response.get("domain").asText();
        }
        return url;
    }

    private /* synthetic */ void lambda$null$62(Supplier isOnlyActiveInstance, String accountId, int instanceNumber, Function onDisconnected) {
        if (((Boolean)isOnlyActiveInstance.get()).booleanValue()) {
            this.subscriptionManager.onTimeout(accountId, instanceNumber);
        }
        this.queueEvent(accountId, () -> (CompletableFuture)onDisconnected.apply(true));
    }

    private /* synthetic */ void lambda$null$58(String instanceId, Supplier isOnlyActiveInstance, Boolean isTimeout, String accountId, int instanceNumber, List listeners, String instanceIndex, SocketInstance socketInstance, String host) {
        if (this.connectedHosts.containsKey(instanceId)) {
            if (((Boolean)isOnlyActiveInstance.get()).booleanValue()) {
                ArrayList<CompletionStage> onDisconnectedFutures = new ArrayList<CompletionStage>();
                if (!isTimeout.booleanValue()) {
                    onDisconnectedFutures.add(this.subscriptionManager.onDisconnected(accountId, instanceNumber));
                }
                for (SynchronizationListener listener : listeners) {
                    onDisconnectedFutures.add(listener.onDisconnected(instanceIndex).exceptionally(e -> {
                        logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about disconnected event", e);
                        return null;
                    }));
                }
                CompletableFuture.allOf(onDisconnectedFutures.toArray(new CompletableFuture[0])).join();
            } else {
                ArrayList<CompletionStage> onStreamClosedFutures = new ArrayList<CompletionStage>();
                this.packetOrderer.onStreamClosed(instanceId);
                socketInstance.synchronizationThrottler.removeIdByParameters(accountId, instanceNumber, host);
                for (SynchronizationListener listener : listeners) {
                    onStreamClosedFutures.add(listener.onStreamClosed(instanceIndex).exceptionally(e -> {
                        logger.error(accountId + ":" + instanceIndex + ": Failed to notify listener about stream closed event", e);
                        return null;
                    }));
                }
                CompletableFuture.allOf(onStreamClosedFutures.toArray(new CompletableFuture[0])).join();
            }
            this.connectedHosts.remove(instanceId);
        }
    }

    protected static class SocketInstance {
        public int id;
        public boolean connected;
        public Map<String, RequestResolve> requestResolves;
        public boolean resolved;
        public CompletableFuture<Void> connectResult;
        public String sessionId;
        public boolean isReconnecting;
        public Socket socket;
        public SynchronizationThrottler synchronizationThrottler;
        public SubscribeLock subscribeLock;
        public double clientId;
        public Boolean firstConnect;

        protected SocketInstance() {
        }
    }

    private static class SubscribeLock {
        public IsoTime recommendedRetryTime;
        public int lockedAtAccounts;
        public long lockedAtTime;
        public String type;

        private SubscribeLock() {
        }
    }

    public static class PacketLoggerOptions
    extends PacketLogger.LoggerOptions {
    }

    public static class EventProcessingOptions {
        public boolean sequentialProcessing = false;
    }

    public static class ClientOptions {
        public String application = "MetaApi";
        public String domain = "agiliumtrade.agiliumtrade.ai";
        public String region;
        public long requestTimeout = 60000L;
        public long connectTimeout = 60000L;
        public int packetOrderingTimeout = 60;
        public SynchronizationThrottler.Options synchronizationThrottler = new SynchronizationThrottler.Options();
        public PacketLoggerOptions packetLogger = new PacketLoggerOptions();
        public RetryOptions retryOpts = new RetryOptions();
        public EventProcessingOptions eventProcessing = new EventProcessingOptions();
        public boolean useSharedClientApi = false;
    }

    private static class ReconnectListenerItem {
        public String accountId;
        public ReconnectListener listener;

        private ReconnectListenerItem() {
        }
    }

    private static class RequestResolve {
        public CompletableFuture<JsonNode> future;
        public String type;

        private RequestResolve() {
        }
    }
}

