/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDemoAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.NewMT4DemoAccount;
import cloud.metaapi.sdk.clients.meta_api.models.NewMT5DemoAccount;
import java.util.concurrent.CompletableFuture;

public class MetatraderDemoAccountClient
extends MetaApiClient {
    public MetatraderDemoAccountClient(HttpClient httpClient, String token) {
        super(httpClient, token);
    }

    public MetatraderDemoAccountClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
    }

    public CompletableFuture<MetatraderDemoAccountDto> createMT4DemoAccount(String profileId, NewMT4DemoAccount account) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("createMT4DemoAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + profileId + "/mt4-demo-accounts", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody((Object)account);
        return this.httpClient.requestJson(opts, MetatraderDemoAccountDto.class);
    }

    public CompletableFuture<MetatraderDemoAccountDto> createMT5DemoAccount(String profileId, NewMT5DemoAccount account) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("createMT5DemoAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/provisioning-profiles/" + profileId + "/mt5-demo-accounts", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody((Object)account);
        return this.httpClient.requestJson(opts, MetatraderDemoAccountDto.class);
    }
}

