/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.OptionsValidator;
import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.Js;
import cloud.metaapi.sdk.util.ServiceProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronizationThrottler {
    private static Logger logger = LogManager.getLogger(SynchronizationThrottler.class);
    private int maxConcurrentSynchronizations;
    private int queueTimeoutInSeconds;
    private int synchronizationTimeoutInSeconds;
    private MetaApiWebsocketClient client;
    private int socketInstanceIndex;
    protected Map<String, Long> synchronizationIds = new ConcurrentHashMap<String, Long>();
    private Map<String, AccountData> accountsBySynchronizationIds = new ConcurrentHashMap<String, AccountData>();
    private List<SynchronizationQueueItem> synchronizationQueue = new ArrayList<SynchronizationQueueItem>();
    private Timer removeOldSyncIdsTimer = null;
    private Timer processQueueTimer = null;

    public SynchronizationThrottler(MetaApiWebsocketClient client, int socketInstanceIndex, Options opts) throws ValidationException {
        OptionsValidator validator = new OptionsValidator();
        validator.validateNonZeroInt(opts.maxConcurrentSynchronizations, "synchronizationThrottler.maxConcurrentSynchronizations");
        validator.validateNonZeroInt(opts.queueTimeoutInSeconds, "synchronizationThrottler.queueTimeoutInSeconds");
        validator.validateNonZeroInt(opts.synchronizationTimeoutInSeconds, "synchronizationThrottler.synchronizationTimeoutInSeconds");
        this.maxConcurrentSynchronizations = opts.maxConcurrentSynchronizations;
        this.queueTimeoutInSeconds = opts.queueTimeoutInSeconds;
        this.synchronizationTimeoutInSeconds = opts.synchronizationTimeoutInSeconds;
        this.client = client;
        this.socketInstanceIndex = socketInstanceIndex;
    }

    void start() {
        if (this.removeOldSyncIdsTimer == null) {
            this.removeOldSyncIdsTimer = new Timer();
            this.removeOldSyncIdsTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SynchronizationThrottler.this.removeOldSyncIdsJob();
                }
            }, 1000L, 1000L);
            this.processQueueTimer = new Timer();
            this.processQueueTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SynchronizationThrottler.this.processQueueJob();
                }
            }, 1000L, 1000L);
        }
    }

    void stop() {
        if (this.removeOldSyncIdsTimer != null) {
            this.removeOldSyncIdsTimer.cancel();
            this.removeOldSyncIdsTimer = null;
            this.processQueueTimer.cancel();
            this.processQueueTimer = null;
        }
    }

    private void removeOldSyncIdsJob() {
        long now = ServiceProvider.getNow().toEpochMilli();
        for (String key : new ArrayList<String>(this.synchronizationIds.keySet())) {
            if (now - this.synchronizationIds.get(key) <= (long)(this.synchronizationTimeoutInSeconds * 1000)) continue;
            this.synchronizationIds.remove(key);
        }
        while (this.synchronizationQueue.size() > 0 && ServiceProvider.getNow().toEpochMilli() - this.synchronizationQueue.get((int)0).queueTime > (long)(this.queueTimeoutInSeconds * 1000)) {
            this.removeFromQueue(this.synchronizationQueue.get((int)0).synchronizationId, "timeout");
        }
        this.advanceQueue();
    }

    public void updateSynchronizationId(String synchronizationId) {
        if (this.accountsBySynchronizationIds.containsKey(synchronizationId)) {
            this.synchronizationIds.put(synchronizationId, ServiceProvider.getNow().toEpochMilli());
        }
    }

    public List<String> getSynchronizingAccounts() {
        ArrayList<String> synchronizingAccounts = new ArrayList<String>();
        this.synchronizationIds.keySet().forEach(key -> {
            AccountData accountData = this.accountsBySynchronizationIds.get(key);
            if (accountData != null && synchronizingAccounts.indexOf(accountData.accountId) == -1) {
                synchronizingAccounts.add(accountData.accountId);
            }
        });
        return synchronizingAccounts;
    }

    public List<String> getActiveSynchronizationIds() {
        return new ArrayList<String>(this.accountsBySynchronizationIds.keySet());
    }

    public int getMaxConcurrentSynchronizations() {
        int calculatedMax = Math.max((int)Math.ceil((double)this.client.getSubscribedAccountIds(this.socketInstanceIndex).size() / 10.0), 1);
        return Math.min(calculatedMax, this.maxConcurrentSynchronizations);
    }

    public boolean isSynchronizationAvailable() {
        if ((Integer)Js.reduce(this.client.getSocketInstances(), (acc, socketInstance) -> acc + socketInstance.synchronizationThrottler.getSynchronizingAccounts().size(), (Object)0) >= this.maxConcurrentSynchronizations) {
            return false;
        }
        return this.getSynchronizingAccounts().size() < this.getMaxConcurrentSynchronizations();
    }

    public void removeIdByParameters(String accountId, int instanceIndex, String host) {
        for (String key : new ArrayList<String>(this.accountsBySynchronizationIds.keySet())) {
            if (!this.accountsBySynchronizationIds.get((Object)key).accountId.equals(accountId) || this.accountsBySynchronizationIds.get((Object)key).instanceIndex != instanceIndex || !((String)Js.or((Object[])new String[]{this.accountsBySynchronizationIds.get((Object)key).host, ""})).equals(Js.or((Object[])new String[]{host, ""}))) continue;
            this.removeSynchronizationId(key);
        }
    }

    public void removeSynchronizationId(String synchronizationId) {
        if (this.accountsBySynchronizationIds.containsKey(synchronizationId)) {
            String accountId = this.accountsBySynchronizationIds.get((Object)synchronizationId).accountId;
            int instanceIndex = this.accountsBySynchronizationIds.get((Object)synchronizationId).instanceIndex;
            String host = (String)Js.or((Object[])new String[]{this.accountsBySynchronizationIds.get((Object)synchronizationId).host, ""});
            for (String key : new ArrayList<String>(this.accountsBySynchronizationIds.keySet())) {
                if (!this.accountsBySynchronizationIds.get((Object)key).accountId.equals(accountId) || this.accountsBySynchronizationIds.get((Object)key).instanceIndex != instanceIndex || !((String)Js.or((Object[])new String[]{this.accountsBySynchronizationIds.get((Object)key).host, ""})).equals(host)) continue;
                this.removeFromQueue(key, "cancel");
                this.accountsBySynchronizationIds.remove(key);
            }
        }
        if (this.synchronizationIds.containsKey(synchronizationId)) {
            this.synchronizationIds.remove(synchronizationId);
        }
        this.advanceQueue();
    }

    public void onDisconnect() {
        this.synchronizationQueue.forEach(synchronization -> synchronization.future.complete("cancel"));
        this.synchronizationIds.clear();
        this.accountsBySynchronizationIds.clear();
        this.synchronizationQueue.clear();
        this.stop();
        this.start();
    }

    private void advanceQueue() {
        for (int index = 0; this.isSynchronizationAvailable() && this.synchronizationQueue.size() > 0 && index < this.synchronizationQueue.size(); ++index) {
            SynchronizationQueueItem queueItem = this.synchronizationQueue.get(index);
            queueItem.future.complete("synchronize");
            this.updateSynchronizationId(queueItem.synchronizationId);
        }
    }

    private void removeFromQueue(String synchronizationId, String result) {
        new ArrayList<SynchronizationQueueItem>(this.synchronizationQueue).forEach(syncItem -> {
            if (syncItem.synchronizationId.equals(synchronizationId)) {
                syncItem.future.complete(result);
            }
        });
        this.synchronizationQueue = this.synchronizationQueue.stream().filter(item -> !item.synchronizationId.equals(synchronizationId)).collect(Collectors.toList());
    }

    private CompletableFuture<Void> processQueueJob() {
        return Async.run(() -> {
            try {
                while (this.synchronizationQueue.size() > 0) {
                    SynchronizationQueueItem queueItem = this.synchronizationQueue.get(0);
                    queueItem.future.join();
                    Async.run(() -> {}).join();
                    if (this.synchronizationQueue.size() <= 0 || !this.synchronizationQueue.get((int)0).synchronizationId.equals(queueItem.synchronizationId)) continue;
                    this.synchronizationQueue.remove(0);
                }
            }
            catch (Throwable err) {
                logger.info("[" + new IsoTime() + "] Error processing queue job", err);
            }
        });
    }

    public CompletableFuture<Boolean> scheduleSynchronize(String accountId, ObjectNode request) {
        return Async.supply(() -> {
            String synchronizationId = request.get("requestId").asText();
            int instanceIndex = request.has("instanceIndex") ? request.get("instanceIndex").asInt() : -1;
            for (String key : new ArrayList<String>(this.accountsBySynchronizationIds.keySet())) {
                if (!this.accountsBySynchronizationIds.get((Object)key).accountId.equals(accountId) || this.accountsBySynchronizationIds.get((Object)key).instanceIndex != instanceIndex) continue;
                this.removeSynchronizationId(key);
            }
            AccountData accountData = new AccountData();
            accountData.accountId = accountId;
            accountData.instanceIndex = instanceIndex;
            accountData.host = request.hasNonNull("host") ? request.get("host").asText() : null;
            this.accountsBySynchronizationIds.put(synchronizationId, accountData);
            if (!this.isSynchronizationAvailable()) {
                final CompletableFuture requestFuture = new CompletableFuture();
                final String sid = synchronizationId;
                this.synchronizationQueue.add(new SynchronizationQueueItem(){
                    {
                        this.synchronizationId = sid;
                        this.future = requestFuture;
                        this.queueTime = ServiceProvider.getNow().toEpochMilli();
                    }
                });
                String result = (String)requestFuture.join();
                if (result.equals("cancel")) {
                    return false;
                }
                if (result.equals("timeout")) {
                    throw new CompletionException((Throwable)new TimeoutException("Account " + accountId + " synchronization " + synchronizationId + "timed out in synchronization queue"));
                }
            }
            this.updateSynchronizationId(synchronizationId);
            this.client.rpcRequest(accountId, request, null).join();
            return true;
        });
    }

    private static class SynchronizationQueueItem {
        public String synchronizationId;
        public CompletableFuture<String> future;
        public long queueTime;

        private SynchronizationQueueItem() {
        }
    }

    private static class AccountData {
        public String accountId;
        public int instanceIndex;
        public String host;

        private AccountData() {
        }
    }

    public static class Options {
        public int maxConcurrentSynchronizations = 15;
        public int queueTimeoutInSeconds = 300;
        public int synchronizationTimeoutInSeconds = 10;
    }
}

