/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.OptionsValidator;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.ExpertAdvisorClient;
import cloud.metaapi.sdk.clients.meta_api.HistoricalMarketDataClient;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderDemoAccountClient;
import cloud.metaapi.sdk.clients.meta_api.ProvisioningProfileClient;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationThrottler;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.LatencyMonitor;
import cloud.metaapi.sdk.meta_api.MetatraderAccountApi;
import cloud.metaapi.sdk.meta_api.MetatraderDemoAccountApi;
import cloud.metaapi.sdk.meta_api.ProvisioningProfileApi;
import cloud.metaapi.sdk.util.Async;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaApi {
    private static Logger logger = LogManager.getLogger(MetaApi.class);
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private ProvisioningProfileApi provisioningProfileApi;
    private MetatraderAccountApi metatraderAccountApi;
    private ConnectionRegistry connectionRegistry;
    private MetatraderDemoAccountApi metatraderDemoAccountApi;
    private LatencyMonitor latencyMonitor;

    public MetaApi(String token) throws IOException {
        try {
            this.initialize(token, null);
        }
        catch (ValidationException e) {
            logger.error("Application name is incorrect", (Throwable)e);
        }
    }

    public MetaApi(String token, Options opts) throws ValidationException, IOException {
        this.initialize(token, opts);
    }

    public ProvisioningProfileApi getProvisioningProfileApi() {
        return this.provisioningProfileApi;
    }

    public MetatraderAccountApi getMetatraderAccountApi() {
        return this.metatraderAccountApi;
    }

    public MetatraderDemoAccountApi getMetatraderDemoAccountApi() {
        return this.metatraderDemoAccountApi;
    }

    public LatencyMonitor getLatencyMonitor() {
        return this.latencyMonitor;
    }

    public void close() {
        this.metaApiWebsocketClient.removeLatencyListener(this.latencyMonitor);
        this.metaApiWebsocketClient.close();
        Async.shutdownExecutor();
    }

    private void initialize(String token, Options opts) throws ValidationException, IOException {
        if (opts == null) {
            opts = new Options();
        }
        if (!opts.application.matches("[a-zA-Z0-9_]+")) {
            throw new ValidationException("Application name must be non-empty string consisting from letters, digits and _ only", null);
        }
        OptionsValidator validator = new OptionsValidator();
        validator.validateNonZeroInt(opts.requestTimeout, "requestTimeout");
        validator.validateNonZeroInt(opts.historicalMarketDataRequestTimeout, "historicalMarketDataRequestTimeout");
        validator.validateNonZeroInt(opts.connectTimeout, "connectTimeout");
        validator.validateNonZeroInt(opts.packetOrderingTimeout, "packetOrderingTimeout");
        validator.validateNonZeroInt(opts.demoAccountRequestTimeout, "demoAccountRequestTimeout");
        HttpClient httpClient = new HttpClient(opts.requestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        HttpClient historicalMarketDataHttpClient = new HttpClient(opts.historicalMarketDataRequestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        HttpClient demoAccountHttpClient = new HttpClient(opts.demoAccountRequestTimeout * 1000, opts.connectTimeout * 1000, opts.retryOpts);
        MetaApiWebsocketClient.ClientOptions websocketOptions = new MetaApiWebsocketClient.ClientOptions();
        websocketOptions.application = opts.application;
        websocketOptions.domain = opts.domain;
        websocketOptions.requestTimeout = (long)opts.requestTimeout * 1000L;
        websocketOptions.connectTimeout = (long)opts.connectTimeout * 1000L;
        websocketOptions.packetOrderingTimeout = opts.packetOrderingTimeout;
        websocketOptions.packetLogger = opts.packetLogger;
        websocketOptions.synchronizationThrottler = opts.synchronizationThrottler;
        websocketOptions.retryOpts = opts.retryOpts;
        websocketOptions.eventProcessing = opts.eventProcessing;
        websocketOptions.useSharedClientApi = opts.useSharedClientApi;
        websocketOptions.region = opts.region;
        this.metaApiWebsocketClient = new MetaApiWebsocketClient(httpClient, token, websocketOptions);
        this.provisioningProfileApi = new ProvisioningProfileApi(new ProvisioningProfileClient(httpClient, token, opts.domain));
        this.connectionRegistry = new ConnectionRegistry(this.metaApiWebsocketClient, opts.application);
        HistoricalMarketDataClient historicalMarketDataClient = new HistoricalMarketDataClient(historicalMarketDataHttpClient, token, opts.region, opts.domain);
        this.metatraderAccountApi = new MetatraderAccountApi(new MetatraderAccountClient(httpClient, token, opts.domain), this.metaApiWebsocketClient, this.connectionRegistry, new ExpertAdvisorClient(httpClient, token, opts.domain), historicalMarketDataClient);
        this.metatraderDemoAccountApi = new MetatraderDemoAccountApi(new MetatraderDemoAccountClient(demoAccountHttpClient, token, opts.domain));
        if (opts.enableLatencyMonitor) {
            this.latencyMonitor = new LatencyMonitor();
            this.metaApiWebsocketClient.addLatencyListener(this.latencyMonitor);
        }
    }

    public static class Options {
        public String application = "MetaApi";
        public String domain = "agiliumtrade.agiliumtrade.ai";
        public String region;
        public int requestTimeout = 60;
        public int connectTimeout = 60;
        public int packetOrderingTimeout = 60;
        public MetaApiWebsocketClient.PacketLoggerOptions packetLogger = new MetaApiWebsocketClient.PacketLoggerOptions();
        public boolean enableLatencyMonitor = false;
        public int maxConcurrentSynchronizations = 5;
        public SynchronizationThrottler.Options synchronizationThrottler = new SynchronizationThrottler.Options();
        public RetryOptions retryOpts = new RetryOptions();
        public int historicalMarketDataRequestTimeout = 60;
        public int demoAccountRequestTimeout = 240;
        public MetaApiWebsocketClient.EventProcessingOptions eventProcessing = new MetaApiWebsocketClient.EventProcessingOptions();
        public boolean useSharedClientApi = false;
    }
}

