package cn.openjava.basic.crypto.utils;

import cn.openjava.basic.crypto.factory.OpenJavaCrypto;
import cn.openjava.basic.crypto.properties.CryptoProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CryptoUtil implements OpenJavaCrypto {
    /**
     * 加密配置
     */
    @Autowired
    private CryptoProperties cryptoProperties;


    /**
     * 加密字符串
     *
     * @param plaintext 明文
     * @return 密文
     */
    @Override
    public String encryptString(String plaintext) {
        return CryptoUtilBuilder.build(cryptoProperties.getCryptoType()).encryptString(plaintext);
    }

    /**
     * 解密字符串
     *
     * @param ciphertext 密文
     * @return 明文
     */
    @Override
    public String decryptString(String ciphertext) {
        return CryptoUtilBuilder.build(cryptoProperties.getCryptoType()).decryptString(ciphertext);
    }
}
