/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys;

import com.ds.cluster.service.ServerEventFactory;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.annotation.nav.TabsAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.server.JDSServer;
import com.ds.system.sys.view.esbbean.LocalEsbBeanGridView;
import com.ds.system.sys.view.esbbean.RemoteEsbBeanGridView;
import com.ds.system.sys.view.service.LocalServiceGridView;
import com.ds.system.sys.view.service.MsgServiceGridView;
import com.ds.system.sys.view.service.RemoteServiceGridView;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/service/"})
@TabsAnnotation(closeBtn=true)
public class ServiceBeanNav {
    @RequestMapping(value={"AllLocalService"}, method={RequestMethod.GET, RequestMethod.POST})
    @ModuleAnnotation(imageClass="spafont spa-icon-settingprj", caption="\u672c\u5730\u670d\u52a1\u7ba1\u7406")
    @GridViewAnnotation(editorPath="LocalEsbBeanInfo", delPath="delService")
    @ResponseBody
    public ListResultModel<List<LocalEsbBeanGridView>> getAllLocalService() {
        List esbBeans = EsbBeanFactory.getInstance().getLocalBeanList();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)esbBeans, LocalEsbBeanGridView.class);
        return userStatusInfo;
    }

    @RequestMapping(value={"AllRemoteService"}, method={RequestMethod.GET, RequestMethod.POST})
    @GridViewAnnotation(editorPath="RemoteEsbBeanInfo", delPath="delService")
    @ModuleAnnotation(imageClass="spafont spa-icon-alignm", caption="\u8fdc\u7a0b\u670d\u52a1\u7ba1\u7406")
    @ResponseBody
    public ListResultModel<List<RemoteEsbBeanGridView>> getAllRemoteService() {
        List esbBeans = EsbBeanFactory.getInstance().getRemoveBeanList();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)esbBeans, RemoteEsbBeanGridView.class);
        return userStatusInfo;
    }

    @GridViewAnnotation(editorPath="ServiceInfo", delPath="delService")
    @ModuleAnnotation(imageClass="spafont spa-icon-c-audio", caption="\u6240\u6709\u6d88\u606f\u4e8b\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"AllAllEvent"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<Set<MsgServiceGridView>> getAllEvent() {
        Set beanSet = ServerEventFactory.getInstance().getAllRegisterEvent();
        List<ExpressionTempBean> esbBeans = Arrays.asList(beanSet.toArray(new ExpressionTempBean[beanSet.size()]));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList(esbBeans, MsgServiceGridView.class);
        return userStatusInfo;
    }

    @RequestMapping(value={"AllBusBeanTemp"}, method={RequestMethod.GET, RequestMethod.POST})
    @GridViewAnnotation(editorPath="ServiceInfo", delPath="delService")
    @ModuleAnnotation(imageClass="spafont spa-icon-action1", caption="\u83b7\u53d6\u6ce8\u518c\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public ListResultModel<List<LocalServiceGridView>> getBusBeanTemp(String flowTypes) {
        ArrayList<EsbFlowType> types = new ArrayList<EsbFlowType>();
        if (flowTypes != null) {
            if (flowTypes.equals("all")) {
                types.addAll(Arrays.asList(EsbFlowType.values()));
            } else {
                String[] flowTypeArr;
                for (String app : flowTypeArr = StringUtility.split((String)flowTypes, (String)";")) {
                    types.add(EsbFlowType.fromType((String)app));
                }
            }
        }
        List esbBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(types.toArray(new EsbFlowType[0]));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)esbBeans, LocalServiceGridView.class);
        return userStatusInfo;
    }

    @GridViewAnnotation(editorPath="ServiceInfo", delPath="delService")
    @ModuleAnnotation(caption="\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"AllRemoteClusterSevice"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<RemoteServiceGridView>> getRemoteClusterSevice() {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            userStatusInfo = PageUtil.getDefaultPageList((List)JDSServer.getInstance().getClusterSevice(), RemoteServiceGridView.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }
}

