/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys;

import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.common.JDSException;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.annotation.nav.TabsAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemType;
import com.ds.server.service.SysWebManager;
import com.ds.system.sys.view.ApplicationGridView;
import com.ds.system.sys.view.ServerNodeGridView;
import com.ds.system.sys.view.system.DevSystemGridView;
import com.ds.system.sys.view.system.SystemGridView;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/sys/"})
@TabsAnnotation(closeBtn=true)
public class SystemNav {
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="spafont spa-icon-coin", caption="\u83b7\u53d6\u6240\u6709\u7cfb\u7edf")
    @RequestMapping(value={"AllSystem"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<SystemGridView>> getAllSystem() {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            JDSServer.getInstance();
            List serverNodes = JDSServer.getClusterClient().getAllServer();
            ArrayList<ServerNode> sysNodes = new ArrayList<ServerNode>();
            for (ServerNode node : serverNodes) {
                JDSServer.getInstance();
                SubSystem subSystem = JDSServer.getClusterClient().getSystem(node.getId());
                if (subSystem == null || subSystem.getType() == null || subSystem.getType().equals((Object)SystemType.dev)) continue;
                sysNodes.add(node);
            }
            userStatusInfo = PageUtil.getDefaultPageList(sysNodes, SystemGridView.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @GridViewAnnotation
    @MethodChinaName(cname="\u79df\u6237\u7ba1\u7406")
    @ModuleAnnotation(imageClass="bpmfont bpmgongzuoliu2")
    @RequestMapping(value={"AllDevSystem"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<DevSystemGridView>> getAllDevSystem() {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            List systems = (List)this.getSysWebManager().getAllSAASSystemInfo().get();
            ArrayList<SubSystem> sysNodes = new ArrayList<SubSystem>();
            for (SubSystem subSystem : systems) {
                if (subSystem == null || subSystem.getType() == null) continue;
                sysNodes.add(subSystem);
            }
            userStatusInfo = PageUtil.getDefaultPageList(sysNodes, DevSystemGridView.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5e94\u7528\u914d\u7f6e")
    @GridViewAnnotation(editorPath="system.application.ApplicationInfo", addPath="system.application.ApplicationInfo")
    @ModuleAnnotation(imageClass="spafont spa-icon-conf1")
    @RequestMapping(value={"AllApplications"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ApplicationGridView>> getApplications() {
        List applications = JDSServer.getClusterClient().getApplications();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)applications, ApplicationGridView.class);
        return userStatusInfo;
    }

    @GridViewAnnotation(editorPath="system.node.AppServerNodeInfo", addPath="system.node.ApplicationInfo")
    @ModuleAnnotation(imageClass="spafont spa-icon-c-toolbar")
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u670d\u52a1")
    @RequestMapping(value={"AllServerNodes"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ServerNodeGridView>> getServerNodes(String code) {
        ServerNodeList serverNodeList = JDSServer.getClusterClient().getServerNodeListByConfigCode(ConfigCode.fromType((String)code));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)serverNodeList.getServerNodeList(), ServerNodeGridView.class);
        return userStatusInfo;
    }

    SysWebManager getSysWebManager() {
        return (SysWebManager)EsbUtil.parExpression((String)"$SysWebManager");
    }
}

