/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.service;

import com.ds.cluster.ServerNode;
import com.ds.common.JDSException;
import com.ds.common.md5.MD5;
import com.ds.common.org.CtOrg;
import com.ds.common.org.CtOrgAdminManager;
import com.ds.common.org.CtPerson;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.annotation.PopTreeViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.enums.CustomMenuItem;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.esd.dsm.domain.annotation.NavDomain;
import com.ds.esd.dsm.domain.enums.NavDomainType;
import com.ds.esd.tool.ui.enums.Dock;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.org.Org;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.server.ct.CtSubSystem;
import com.ds.server.service.SysWebManager;
import com.ds.system.sys.view.DeparmentTopTree;
import com.ds.system.sys.view.FolderTopTree;
import com.ds.system.sys.view.PersonPopTree;
import com.ds.system.sys.view.system.DevSystemFormView;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.web.annotation.Aggregation;
import com.ds.web.annotation.AggregationType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@MethodChinaName(cname="\u5b50\u7cfb\u7edf", imageClass="spafont spa-icon-coin")
@RequestMapping(value={"/system/dev/"})
@Aggregation(type=AggregationType.customDomain, rootClass=DevSystemService.class)
@NavDomain(type=NavDomainType.menu)
public class DevSystemService {
    @RequestMapping(method={RequestMethod.POST}, value={"DevSystemInfo"})
    @FormViewAnnotation(saveUrl="updateDevSystemInfo")
    @DialogAnnotation(width="650", height="350")
    @ModuleAnnotation(caption="\u7f16\u8f91\u670d\u52a1\u4fe1\u606f")
    @APIEventAnnotation(bindMenu={CustomMenuItem.editor})
    @ResponseBody
    public ResultModel<DevSystemFormView> getDevSystemInfo(String sysId) {
        ResultModel resultModel = new ResultModel();
        try {
            ServerNode serverNode = JDSServer.getClusterClient().getServerNodeById(sysId);
            DevSystemFormView serviceView = new DevSystemFormView(serverNode);
            resultModel.setData((Object)serviceView);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultModel = new ErrorResultModel();
            ((ErrorResultModel)resultModel).setErrdes(e.getMessage());
        }
        return resultModel;
    }

    @MethodChinaName(cname="\u6dfb\u52a0SAAS\u7528\u6237")
    @RequestMapping(method={RequestMethod.POST}, value={"AddSaaSSystem"})
    @FormViewAnnotation(saveUrl="updateDevSystemInfo")
    @DialogAnnotation(width="650", height="300")
    @ModuleAnnotation(caption="\u6dfb\u52a0SAAS\u7528\u6237")
    @APIEventAnnotation(isAllform=true, autoRun=true, bindMenu={CustomMenuItem.add})
    @ResponseBody
    public ResultModel<DevSystemFormView> addSaaSSystem() {
        ResultModel resultModel = new ResultModel();
        try {
            CtSubSystem subSystem = new CtSubSystem();
            subSystem.setSysId(UUID.randomUUID().toString());
            subSystem.setName("\u65b0\u5efa\u7cfb\u7edf");
            Org topOrg = CtOrgAdminManager.getInstance().createTopOrg(subSystem.getSysId(), subSystem.getName());
            subSystem.setAdminId(topOrg.getLeaderId());
            subSystem.setOrgId(topOrg.getOrgId());
            Folder folder = CtVfsFactory.getCtVfsService().getFolderByPath("form/");
            Folder rootFolder = folder.createChildFolder(subSystem.getSysId(), subSystem.getAdminId());
            subSystem.setVfsPath(rootFolder.getPath());
            this.getSysWebManager().saveSystemInfo((SubSystem)subSystem).get();
            DevSystemFormView serviceView = new DevSystemFormView((SubSystem)subSystem);
            resultModel.setData((Object)serviceView);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultModel = new ErrorResultModel();
            ((ErrorResultModel)resultModel).setErrdes(e.getMessage());
        }
        return resultModel;
    }

    @MethodChinaName(cname="\u7ed1\u5b9a\u7cfb\u7edf\u673a\u6784\u4fe1\u606f")
    @RequestMapping(value={"bindOrgSys"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(isAllform=true, callback={CustomCallBack.Close})
    @ResponseBody
    public ResultModel<Boolean> bindOrgSys(String sysId, String AddOrg2SysTree) {
        ResultModel userStatusInfo = new ResultModel();
        String[] orgIds = new String[]{};
        if (AddOrg2SysTree != null) {
            for (String orgId : orgIds = StringUtility.split((String)AddOrg2SysTree, (String)";")) {
                CtSubSystem subSystem = (CtSubSystem)JDSServer.getClusterClient().getSystem(sysId);
                subSystem.setOrgId(orgId);
                try {
                    this.getSysWebManager().saveSystemInfo((SubSystem)subSystem).get();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
            }
        }
        return userStatusInfo;
    }

    @RequestMapping(value={"AddOrg2Sys"}, method={RequestMethod.GET, RequestMethod.POST})
    @DialogAnnotation(width="350", height="400")
    @PopTreeViewAnnotation(saveUrl="bindOrgSys")
    @ModuleAnnotation(dynLoad=true, caption="\u7ed1\u5b9a\u7ec4\u7ec7\u673a\u6784", dock=Dock.fill)
    @APIEventAnnotation(isAllform=true, autoRun=true)
    @ResponseBody
    public TreeListResultModel<List<DeparmentTopTree>> addOrg2Sys(String sysId) {
        TreeListResultModel result = new TreeListResultModel();
        try {
            ArrayList<DeparmentTopTree> topTrees = new ArrayList<DeparmentTopTree>();
            topTrees.add(new DeparmentTopTree(""));
            result.setData(topTrees);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u7ed1\u5b9a\u7a7a\u95f4")
    @RequestMapping(value={"bindSpaceSys"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(isAllform=true, callback={CustomCallBack.Close})
    @ResponseBody
    public ResultModel<Boolean> bindSpaceSys(String sysId, String AddSpace2SysTree) {
        ResultModel result = new ResultModel();
        String[] folderIds = new String[]{};
        if (AddSpace2SysTree != null) {
            for (String folderId : folderIds = StringUtility.split((String)AddSpace2SysTree, (String)";")) {
                try {
                    CtSubSystem subSystem = (CtSubSystem)JDSServer.getClusterClient().getSystem(sysId);
                    Folder folder = CtVfsFactory.getCtVfsService().getFolderById(folderId);
                    subSystem.setVfsPath(folder.getPath());
                    this.getSysWebManager().saveSystemInfo((SubSystem)subSystem).get();
                }
                catch (JDSException e) {
                    result = new ErrorResultModel();
                    ((ErrorResultModel)result).setErrcode(e.getErrorCode());
                    ((ErrorResultModel)result).setErrdes(e.getMessage());
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"AddPerson2Sys"}, method={RequestMethod.GET, RequestMethod.POST})
    @DialogAnnotation(width="350", height="400")
    @PopTreeViewAnnotation(saveUrl="bindPersonSys")
    @ModuleAnnotation(dynLoad=true, caption="\u7ed1\u5b9a\u7ba1\u7406\u5458\u8d26\u6237", dock=Dock.fill)
    @APIEventAnnotation(isAllform=true, autoRun=true)
    @ResponseBody
    public TreeListResultModel<List<PersonPopTree>> addPerson2Sys(String sysId) {
        TreeListResultModel result = new TreeListResultModel();
        ArrayList<PersonPopTree> topTrees = new ArrayList<PersonPopTree>();
        SubSystem subSystem = JDSServer.getClusterClient().getSystem(sysId.toString());
        try {
            Org org = CtOrgAdminManager.getInstance().getOrgById(subSystem.getOrgId());
            topTrees.add(new PersonPopTree("", org));
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        result.setData(topTrees);
        return result;
    }

    @MethodChinaName(cname="\u7ed1\u5b9a\u7ba1\u7406\u5458\u8d26\u6237")
    @RequestMapping(value={"bindPersonSys"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(isAllform=true, callback={CustomCallBack.Close})
    @ResponseBody
    public ResultModel<Boolean> bindPersonSys(String sysId, String AddPerson2SysTree) {
        ResultModel result = new ResultModel();
        String[] personIds = new String[]{};
        if (AddPerson2SysTree != null) {
            for (String personId : personIds = StringUtility.split((String)AddPerson2SysTree, (String)";")) {
                try {
                    CtSubSystem subSystem = (CtSubSystem)JDSServer.getClusterClient().getSystem(sysId);
                    if (!personId.startsWith("org")) {
                        subSystem.setAdminId(personId);
                    }
                    this.getSysWebManager().saveSystemInfo((SubSystem)subSystem).get();
                }
                catch (JDSException e) {
                    result = new ErrorResultModel();
                    ((ErrorResultModel)result).setErrcode(e.getErrorCode());
                    ((ErrorResultModel)result).setErrdes(e.getMessage());
                }
            }
        }
        return result;
    }

    @MethodChinaName(cname="\u7ed1\u5b9a\u7a7a\u95f4")
    @RequestMapping(value={"AddSpace2Sys"}, method={RequestMethod.GET, RequestMethod.POST})
    @PopTreeViewAnnotation(saveUrl="bindSpaceSys")
    @DialogAnnotation(width="350", height="400")
    @ModuleAnnotation(dynLoad=true, caption="\u7ed1\u5b9a\u7a7a\u95f4", dock=Dock.fill)
    @APIEventAnnotation(isAllform=true, autoRun=true)
    @ResponseBody
    public TreeListResultModel<List<FolderTopTree>> addSpace2Sys(String sysId) {
        TreeListResultModel result = new TreeListResultModel();
        ArrayList<FolderTopTree> topTrees = new ArrayList<FolderTopTree>();
        try {
            topTrees.add(new FolderTopTree(""));
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        result.setData(topTrees);
        return result;
    }

    ResultModel<Boolean> addSystem(SubSystem subSystem) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            this.getSysWebManager().saveSystemInfo(subSystem).get();
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u7cfb\u7edf\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"updateDevSystemInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(callback={CustomCallBack.Close}, bindMenu={CustomMenuItem.formSave})
    @ResponseBody
    public ResultModel<Boolean> updateDevSystemInfo(@RequestBody DevSystemFormView subSystem) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            String orgName = subSystem.getOrgname();
            String orgId = subSystem.getOrgId();
            CtOrg topOrg = null;
            if (orgId == null || orgId.equals("")) {
                topOrg = (CtOrg)CtOrgAdminManager.getInstance().createTopOrg(subSystem.getSysId(), orgName);
                subSystem.setOrgId(topOrg.getOrgId());
            } else {
                topOrg = (CtOrg)CtOrgAdminManager.getInstance().getOrgById(orgId);
                if (topOrg == null) {
                    topOrg = (CtOrg)CtOrgAdminManager.getInstance().createTopOrg(subSystem.getSysId(), orgName);
                    subSystem.setOrgId(topOrg.getOrgId());
                } else if (orgName == null || !topOrg.getName().equals(orgName)) {
                    topOrg.setName(orgName);
                    CtOrgAdminManager.getInstance().saveOrg(topOrg);
                }
            }
            String vfsPath = subSystem.getVfsPath();
            if (vfsPath == null || vfsPath.equals("")) {
                Folder folder = CtVfsFactory.getCtVfsService().mkDir("form/" + orgName);
                subSystem.setVfsPath(folder.getPath());
            }
            String personId = subSystem.getAdminId();
            String defaultAdminAccount = subSystem.getPersonname();
            if (!defaultAdminAccount.startsWith(subSystem.getEnname() + "_")) {
                defaultAdminAccount = subSystem.getEnname() + "_" + defaultAdminAccount;
            }
            if (CtOrgAdminManager.getInstance().getPersonByAccount(defaultAdminAccount) != null) {
                defaultAdminAccount = defaultAdminAccount + "_" + StringUtility.createRandom((boolean)true, (int)3);
            }
            CtPerson person = null;
            person = personId == null || personId.equals("") ? (CtPerson)topOrg.getLeader() : (CtPerson)CtOrgAdminManager.getInstance().getPersonById(personId);
            if (person == null) {
                person = (CtPerson)CtOrgAdminManager.getInstance().createPerson(topOrg.getOrgId(), defaultAdminAccount, subSystem.getPersonname());
                CtOrgAdminManager.getInstance().savePerson(person);
                subSystem.setAdminId(person.getID());
            } else if (!defaultAdminAccount.equals(person.getAccount())) {
                person.setAccount(defaultAdminAccount);
                person.setName(subSystem.getPersonname());
                person.setPassword(MD5.getHashString((String)"admin"));
                CtOrgAdminManager.getInstance().savePerson(person);
            }
            this.getSysWebManager().saveSystemInfo((SubSystem)subSystem).get();
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @RequestMapping(value={"deleteSystem"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(callback={CustomCallBack.Reload}, bindMenu={CustomMenuItem.delete})
    @ResponseBody
    public ResultModel<Boolean> deleteSystem(String systemIds) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            String[] systemIdArr;
            for (String systemId : systemIdArr = systemIds.split(";")) {
                SubSystem subSystem = (SubSystem)this.getSysWebManager().getSubSystemInfo(systemId).get();
            }
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    SysWebManager getSysWebManager() {
        return (SysWebManager)EsbUtil.parExpression((String)"$SysWebManager");
    }
}

