/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.service;

import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.esd.dsm.domain.annotation.NavDomain;
import com.ds.esd.dsm.domain.enums.NavDomainType;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;
import com.ds.system.sys.view.ServerNodeFormView;
import com.ds.system.sys.view.ServerNodeGridView;
import com.ds.web.annotation.Aggregation;
import com.ds.web.annotation.AggregationType;
import com.ds.web.util.PageUtil;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@MethodChinaName(cname="\u96c6\u7fa4\u670d\u52a1", imageClass="spafont spa-icon-c-toolbar")
@RequestMapping(value={"/system/node/"})
@Aggregation(type=AggregationType.customDomain, rootClass=ServerNodeServcie.class)
@NavDomain(type=NavDomainType.menu)
public class ServerNodeServcie {
    @GridViewAnnotation(editorPath="system.sys.ServerNodeInfo", delPath="delServerNode")
    @ModuleAnnotation(caption="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u670d\u52a1")
    @RequestMapping(value={"AllServerNodes"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ServerNodeGridView>> getAllServerNodes(String code) {
        ServerNodeList serverNodeList = JDSServer.getClusterClient().getServerNodeListByConfigCode(ConfigCode.fromType((String)code));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)serverNodeList.getServerNodeList(), ServerNodeGridView.class);
        return userStatusInfo;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"ServerNodeInfo"})
    @ModuleAnnotation(caption="\u7f16\u8f91\u8282\u70b9\u4fe1\u606f")
    @DialogAnnotation(width="350", height="300")
    @FormViewAnnotation(saveUrl="saveServerNode")
    @ResponseBody
    public ResultModel<ServerNodeFormView> getServerNodeInfo(String id) {
        ResultModel resultModel = new ResultModel();
        try {
            ServerNode cApplication = JDSServer.getClusterClient().getServerNodeById(id);
            ServerNodeFormView serverNodeView = new ServerNodeFormView(cApplication);
            resultModel.setData((Object)serverNodeView);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultModel = new ErrorListResultModel();
            ((ErrorResultModel)resultModel).setErrdes(e.getMessage());
        }
        return resultModel;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f")
    @RequestMapping(value={"saveServerNode"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(callback={CustomCallBack.ReloadParent, CustomCallBack.Close})
    @ResponseBody
    public ResultModel<Boolean> saveServerNode(@RequestBody ServerNode serverNode) {
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u5220\u9664\u8282\u70b9")
    @RequestMapping(value={"delServerNode"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(callback={CustomCallBack.Reload, CustomCallBack.ReloadParent})
    @ResponseBody
    public ResultModel<Boolean> delServerNode(String id) {
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }
}

