/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.service;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionParameter;
import com.ds.esb.config.manager.ServiceBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceNode {
    protected static final transient Log logger = LogFactory.getLog((String)"DAO", ServiceNode.class);
    public String id;
    public String path;
    public boolean group = false;
    public String key;
    public String imageClass = "spafot spa-icon-c-";
    public String caption;
    public String expression;
    public List<ExpressionParameter> parameters;
    public boolean iniFold = false;
    public List<ServiceNode> sub;
    public Map<String, String> tagVar = new HashMap<String, String>();

    public ServiceNode(String parent, Method methodBean) {
        this.caption = methodBean.getName();
        this.id = parent + "." + methodBean.getName();
    }

    public ServiceNode(ServiceBean bean) {
        this.caption = bean.getId() + "(" + (bean.getName() == null ? bean.getId() : bean.getName()) + ")";
        this.id = this.getPath();
        this.expression = bean.getExpression();
        this.parameters = bean.getParams();
        try {
            Class clazz = ClassUtility.loadClass((String)bean.getClazz());
            Method[] methods = clazz.getDeclaredMethods();
            if (methods.length > 0) {
                this.sub = new ArrayList<ServiceNode>();
                for (Method methodBean : methods) {
                    this.sub.add(new ServiceNode("$" + bean.getId(), methodBean));
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
    }

    public ServiceNode(EsbFlowType type) {
        this.caption = type.getType() + "(" + type.getName() + ")";
        this.id = type.getType();
        List serviceBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(new EsbFlowType[]{type});
        if (serviceBeans.size() > 0) {
            this.sub = new ArrayList<ServiceNode>();
            for (ServiceBean bean : serviceBeans) {
                this.sub.add(new ServiceNode(bean));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean isIniFold() {
        return this.iniFold;
    }

    public void setIniFold(boolean iniFold) {
        this.iniFold = iniFold;
    }

    public List<ServiceNode> getSub() {
        return this.sub;
    }

    public void setSub(List<ServiceNode> sub) {
        this.sub = sub;
    }

    public Map<String, String> getTagVar() {
        return this.tagVar;
    }

    public void setTagVar(Map<String, String> tagVar) {
        this.tagVar = tagVar;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public List<ExpressionParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ExpressionParameter> parameters) {
        this.parameters = parameters;
    }
}

