/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view;

import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.config.CApplication;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.form.annotation.FormAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;
import java.util.List;

@BottomBarMenu
@FormAnnotation(col=1, bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close})
public class ApplicationFormView {
    @CustomAnnotation(caption="\u6807\u8bc6", uid=true)
    private String code;
    @CustomAnnotation(caption="\u540d\u79f0")
    private String name;
    @CustomAnnotation(caption="\u90e8\u7f72\u8282\u70b9")
    private String nodeIds = "";
    @CustomAnnotation(caption="\u5728\u7ebf\u8282\u70b9")
    private String nolineNodeIds = "";
    @CustomAnnotation(caption="\u8fde\u63a5Session")
    private String connectionHandle;
    @CustomAnnotation(caption="\u8ba4\u8bc1\u65b9\u5f0f")
    private String jdsService;
    @CustomAnnotation(caption="\u914d\u7f6e\u6587\u4ef6\u8def\u5f84")
    private String configPath;
    @CustomAnnotation(caption="\u7528\u6237\u8868\u8fbe\u5f0f", hidden=true)
    private String userexpression;
    @CustomAnnotation(caption="\u96c6\u7fa4\u7ba1\u7406\u5668", hidden=true)
    private String clusterManagerClass;

    public ApplicationFormView(CApplication application) {
        ServerNodeList node = JDSServer.getClusterClient().getServerNodeListByConfigCode(ConfigCode.fromType((String)application.getConfigCode()));
        this.code = application.getSysId();
        this.name = application.getName();
        List servernodes = node.getServerNodeList();
        for (ServerNode subserverNode : servernodes) {
            String nodeId = subserverNode.getId();
            this.nodeIds = this.nodeIds + subserverNode.getId() + " ";
            if (!JDSServer.getClusterClient().getSystemStatus(subserverNode.getId()).equals((Object)SystemStatus.ONLINE)) continue;
            this.nolineNodeIds = this.nolineNodeIds + nodeId + " ";
        }
        this.configPath = application.getConfigPath();
        this.connectionHandle = application.getConnectionHandle() != null ? application.getConnectionHandle().getImplementation() : "";
        this.jdsService = application.getJdsService() != null ? application.getJdsService().getImplementation() : "";
        this.userexpression = node.getUserexpression();
        this.clusterManagerClass = node.getClusterManagerClass();
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getNolineNodeIds() {
        return this.nolineNodeIds;
    }

    public void setNolineNodeIds(String nolineNodeIds) {
        this.nolineNodeIds = nolineNodeIds;
    }

    public String getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(String nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String getUserexpression() {
        return this.userexpression;
    }

    public void setUserexpression(String userexpression) {
        this.userexpression = userexpression;
    }

    public String getClusterManagerClass() {
        return this.clusterManagerClass;
    }

    public void setClusterManagerClass(String clusterManagerClass) {
        this.clusterManagerClass = clusterManagerClass;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getConnectionHandle() {
        return this.connectionHandle;
    }

    public void setConnectionHandle(String connectionHandle) {
        this.connectionHandle = connectionHandle;
    }

    public String getJdsService() {
        return this.jdsService;
    }

    public void setJdsService(String jdsService) {
        this.jdsService = jdsService;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

