/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view;

import com.ds.common.JDSException;
import com.ds.common.org.CtOrgAdminManager;
import com.ds.common.query.Operator;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.TreeAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.esd.formula.service.DeparmentFService;
import com.ds.esd.tool.ui.component.list.TreeListItem;
import com.ds.esd.tool.ui.enums.SelModeType;
import com.ds.org.Org;
import com.ds.org.query.OrgCondition;
import com.ds.org.query.OrgConditionKey;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TreeAnnotation(heplBar=true, caption="\u9009\u62e9\u90e8\u95e8", bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close}, selMode=SelModeType.singlecheckbox, customService={DeparmentFService.class})
public class DeparmentTopTree
extends TreeListItem {
    @CustomAnnotation(pid=true)
    String pattern = "";
    @CustomAnnotation(pid=true)
    String sysId;

    public DeparmentTopTree(String pattern) throws JDSException {
        this.imageClass = "bpmfont bpm-gongzuoliu-moxing";
        this.caption = "\u7ec4\u7ec7\u673a\u6784";
        this.id = "allOrg";
        OrgCondition condition = new OrgCondition(OrgConditionKey.ORG_PARENTID, Operator.EQUALS, (Object)"00000000-0000-0000-0000-000000000000");
        List orgs = (List)CtOrgAdminManager.getInstance().findOrgs(condition).get();
        for (Org org : orgs) {
            if (!this.checkChild(pattern, org)) continue;
            this.addChild(new DeparmentTopTree(pattern, org));
        }
    }

    public DeparmentTopTree(String pattern, Org org) {
        this.caption = org.getName();
        this.setId(org.getOrgId());
        this.setIniFold(false);
        this.tagVar = new HashMap();
        this.imageClass = "spafont spa-icon-c-treeview";
        this.tagVar.put("orgId", org.getOrgId());
        if (org.getChildrenList() != null && org.getChildrenList().size() > 0) {
            for (Org childorg : org.getChildrenList()) {
                if (!this.checkChild(pattern, childorg)) continue;
                this.addChild(new DeparmentTopTree(pattern, childorg));
            }
        }
    }

    private boolean checkChild(String pattern, Org org) {
        if (this.pattern(pattern, org)) {
            return true;
        }
        List orgs = org.getChildrenRecursivelyList();
        for (Org childOrg : orgs) {
            if (!this.pattern(pattern, childOrg)) continue;
            return true;
        }
        return false;
    }

    private boolean pattern(String pattern, Org org) {
        if (pattern != null && !pattern.equals("")) {
            Pattern p = Pattern.compile(pattern, 2);
            Matcher namematcher = p.matcher(org.getName());
            return namematcher.find();
        }
        return true;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

