/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view;

import com.ds.cluster.ServerNode;
import com.ds.cluster.service.ServerEventFactory;
import com.ds.common.JDSException;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.form.annotation.FormAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.org.OrgManager;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemNodeType;
import com.ds.server.eumus.SystemStatus;
import com.ds.system.sys.view.system.XUISystem;
import java.util.List;

@BottomBarMenu
@FormAnnotation(col=1, bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close})
public class ServerNodeFormView {
    @CustomAnnotation(caption="\u6807\u8bc6", uid=true, hidden=true)
    String id;
    @CustomAnnotation(caption="\u8282\u70b9\u540d\u79f0")
    String name;
    @CustomAnnotation(caption="\u6700\u5927\u8fde\u63a5\u6570")
    Integer maxconnection = 2000;
    @CustomAnnotation(caption="\u6700\u5c0f\u8fde\u63a5\u6570")
    Integer minconnection = 200;
    @CustomAnnotation(caption="\u8d85\u65f6\u65f6\u95f4")
    String timeout = "60";
    @CustomAnnotation(caption="URL")
    String url = "";
    @CustomAnnotation(caption="\u8868\u8fbe\u5f0f")
    String userexpression;
    @CustomAnnotation(caption="\u7c7b\u578b")
    SystemNodeType type;
    @CustomAnnotation(hidden=true)
    String gwmserver;
    @CustomAnnotation(caption="\u8ba2\u9605\u6d88\u606f")
    String repeatEventKey = "";
    @CustomAnnotation(hidden=true)
    public SystemStatus status;
    @CustomAnnotation(hidden=true)
    public int currCount;
    @CustomAnnotation(hidden=true)
    public int maxCounts;
    @CustomAnnotation(hidden=true)
    public Integer checkTimes = 0;

    public ServerNodeFormView(ServerNode node) {
        SubSystem subSystem = null;
        try {
            JDSServer.getInstance();
            subSystem = JDSServer.getClusterClient().getSystem(node.getId());
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        try {
            XUISystem e = new XUISystem(node);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        String systemId = subSystem.getSysId();
        OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)subSystem.getConfigname());
        this.status = JDSServer.getClusterClient().getSystemStatus(systemId);
        this.id = node.getId();
        this.name = node.getName();
        if (node.getMaxconnection() != null) {
            this.maxconnection = Integer.valueOf(node.getMaxconnection());
        }
        if (node.getMinconnection() != null) {
            this.minconnection = Integer.valueOf(node.getMinconnection());
        }
        this.timeout = node.getTimeout();
        this.url = node.getUrl();
        this.userexpression = node.getUserexpression();
        this.type = node.getType();
        this.checkTimes = node.getCheckTimes();
        ServerEventFactory factory = ServerEventFactory.getInstance();
        List serviceBeans = factory.getRegisterEventByCode(node.getId());
        for (ServiceBean serviceBean : serviceBeans) {
            this.repeatEventKey = this.repeatEventKey + serviceBean.getId() + ",";
        }
        if (this.repeatEventKey.endsWith(",")) {
            this.repeatEventKey = this.repeatEventKey.substring(0, this.repeatEventKey.length() - 1);
        }
    }

    public String getRepeatEventKey() {
        return this.repeatEventKey;
    }

    public void setRepeatEventKey(String repeatEventKey) {
        this.repeatEventKey = repeatEventKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaxconnection() {
        return this.maxconnection;
    }

    public void setMaxconnection(Integer maxconnection) {
        this.maxconnection = maxconnection;
    }

    public Integer getMinconnection() {
        return this.minconnection;
    }

    public void setMinconnection(Integer minconnection) {
        this.minconnection = minconnection;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserexpression() {
        return this.userexpression;
    }

    public void setUserexpression(String userexpression) {
        this.userexpression = userexpression;
    }

    public SystemNodeType getType() {
        return this.type;
    }

    public void setType(SystemNodeType type) {
        this.type = type;
    }

    public String getGwmserver() {
        return this.gwmserver;
    }

    public void setGwmserver(String gwmserver) {
        this.gwmserver = gwmserver;
    }

    public SystemStatus getStatus() {
        return this.status;
    }

    public void setStatus(SystemStatus status) {
        this.status = status;
    }

    public int getCurrCount() {
        return this.currCount;
    }

    public void setCurrCount(int currCount) {
        this.currCount = currCount;
    }

    public int getMaxCounts() {
        return this.maxCounts;
    }

    public void setMaxCounts(int maxCounts) {
        this.maxCounts = maxCounts;
    }

    public Integer getCheckTimes() {
        return this.checkTimes;
    }

    public void setCheckTimes(Integer checkTimes) {
        this.checkTimes = checkTimes;
    }

    public String toString() {
        return "id=" + this.id + ";serverurl" + this.url;
    }
}

