/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view;

import com.ds.cluster.ServerNode;
import com.ds.common.JDSException;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.ImageAnnotation;
import com.ds.esd.custom.gallery.annotation.GalleryAnnotation;
import com.ds.esd.custom.grid.enums.GridMenu;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;

@GalleryAnnotation(customMenu={GridMenu.Reload, GridMenu.Add, GridMenu.Delete})
public class SystemItemView {
    @CustomAnnotation
    String caption;
    @CustomAnnotation(hidden=true)
    String sysId;
    @CustomAnnotation(uid=true, hidden=true)
    String id;
    @CustomAnnotation(caption="\u6a21\u677f\u540d\u79f0", captionField=true)
    String comment;
    @ImageAnnotation
    @CustomAnnotation(caption="\u56fe\u7247", captionField=true)
    String image = "/RAD/img/project.png";

    public SystemItemView() {
    }

    public SystemItemView(SubSystem system) {
        this.comment = system.getName();
        this.sysId = system.getSysId();
        this.image = system.getIcon();
        this.id = system.getSysId();
        this.caption = "";
    }

    public SystemItemView(ServerNode node) throws JDSException {
        JDSServer.getInstance();
        SubSystem system = JDSServer.getClusterClient().getSystem(node.getId());
        if (system == null) {
            throw new JDSException("subSystem is null systemId is[" + node.getId() + "] systemName is[" + node.getName() + "]");
        }
        this.comment = system.getName();
        this.sysId = system.getSysId();
        this.image = system.getIcon();
        this.id = system.getSysId();
        this.caption = "";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

