/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.esbbean;

import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbBeanType;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.FieldAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.form.annotation.FormAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.server.SubSystem;

@BottomBarMenu
@FormAnnotation(col=2, bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close})
public class LocalEsbBeanFormView {
    @CustomAnnotation(caption="\u540d\u79f0")
    private String cnname;
    @CustomAnnotation(caption="\u6807\u8bc6", uid=true)
    private String id;
    @CustomAnnotation(caption="\u670d\u52a1\u6807\u8bc6", hidden=true)
    private String serverKey;
    @FieldAnnotation(colWidth="20em", colSpan=-1)
    @CustomAnnotation(caption="\u914d\u7f6e\u5730\u5740")
    private String path;
    @FieldAnnotation(colSpan=-1, rowHeight="150")
    @CustomAnnotation(caption="\u63cf\u8ff0")
    private String desc;
    @CustomAnnotation(caption="\u670d\u52a1\u5730\u5740", hidden=true)
    private String serverUrl;
    @CustomAnnotation(caption="\u8bbf\u95ee\u5b89\u5168", hidden=true)
    private TokenType tokenType = TokenType.guest;
    @CustomAnnotation(caption="\u670d\u52a1\u7c7b\u578b", hidden=true)
    private EsbBeanType esbtype = EsbBeanType.Local;
    @CustomAnnotation(caption="\u751f\u547d\u5468\u671f", hidden=true)
    private ContextType type;
    @CustomAnnotation(caption="\u7528\u6237\u540d", hidden=true)
    private String username;

    public LocalEsbBeanFormView(EsbBean bean) {
        this.id = bean.getId();
        this.cnname = bean.getCnname();
        this.tokenType = bean.getTokenType();
        this.esbtype = bean.getEsbtype();
        this.serverUrl = bean.getServerUrl();
        if (this.serverUrl != null && !this.serverUrl.equals("")) {
            this.esbtype = EsbBeanType.Cluster;
        }
        this.desc = bean.getDesc();
        this.serverKey = bean.getServerKey();
        this.type = bean.getType();
        this.path = bean.getPath();
        this.username = bean.getUsername();
    }

    public LocalEsbBeanFormView(SubSystem system) {
        this.id = system.getEnname();
        this.cnname = system.getName();
        this.tokenType = system.getTokenType();
        this.esbtype = EsbBeanType.Cluster;
        this.serverUrl = system.getUrl();
        this.desc = system.getVfsPath();
        this.serverKey = system.getEnname();
        this.type = ContextType.Server;
        this.path = system.getUrl();
        this.username = system.getAdminId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCnname() {
        return this.cnname;
    }

    public void setCnname(String cnname) {
        this.cnname = cnname;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public ContextType getType() {
        return this.type;
    }

    public void setType(ContextType type) {
        this.type = type;
    }

    public EsbBeanType getEsbtype() {
        return this.esbtype;
    }

    public void setEsbtype(EsbBeanType esbtype) {
        this.esbtype = esbtype;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }
}

