/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.service;

import com.ds.common.util.ClassUtility;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.grid.annotation.GridAnnotation;
import com.ds.esd.custom.grid.annotation.PageBar;
import com.ds.esd.custom.grid.enums.CustomGridEvent;
import com.ds.esd.custom.grid.enums.GridMenu;
import com.ds.system.sys.service.ServiceNode;
import com.ds.system.sys.view.service.LocalService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@PageBar
@GridAnnotation(customService={LocalService.class}, customMenu={GridMenu.Reload, GridMenu.Add, GridMenu.Delete}, event={CustomGridEvent.editor})
public class LocalServiceGridView {
    @CustomAnnotation(caption="\u540d\u79f0")
    public String caption;
    @CustomAnnotation(caption="\u8868\u8fbe\u5f0f")
    public String expression;
    @CustomAnnotation(caption="UID", uid=true)
    public String id;
    @CustomAnnotation(caption="\u8def\u5f84", hidden=true)
    public String path;
    @CustomAnnotation(caption="\u662f\u5426", hidden=true)
    public boolean group = false;
    @CustomAnnotation(caption="\u6807\u8bc6")
    public String key;
    @CustomAnnotation(caption="\u56fe\u6807", hidden=true)
    public String imageClass = "spafot spa-icon-c-";
    @CustomAnnotation(caption="\u662f\u5426\u5c55\u5f00", hidden=true)
    public boolean iniFold = false;
    public List<ServiceNode> sub;

    public LocalServiceGridView(String parent, Method methodBean) {
        this.caption = methodBean.getName();
        this.id = parent + "." + methodBean.getName();
    }

    public LocalServiceGridView(ServiceBean bean) {
        this.caption = bean.getId() + "(" + (bean.getName() == null ? bean.getId() : bean.getName()) + ")";
        this.id = this.getPath();
        this.expression = bean.getExpression();
        try {
            Class clazz = ClassUtility.loadClass((String)bean.getClazz());
            Method[] methods = clazz.getDeclaredMethods();
            if (methods.length > 0) {
                this.sub = new ArrayList<ServiceNode>();
                for (Method methodBean : methods) {
                    this.sub.add(new ServiceNode("$" + bean.getId(), methodBean));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public LocalServiceGridView(EsbFlowType type) {
        this.caption = type.getType() + "(" + type.getName() + ")";
        this.id = type.getType();
        List serviceBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(new EsbFlowType[]{type});
        if (serviceBeans.size() > 0) {
            this.sub = new ArrayList<ServiceNode>();
            for (ServiceBean bean : serviceBeans) {
                this.sub.add(new ServiceNode(bean));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean isIniFold() {
        return this.iniFold;
    }

    public void setIniFold(boolean iniFold) {
        this.iniFold = iniFold;
    }

    public List<ServiceNode> getSub() {
        return this.sub;
    }

    public void setSub(List<ServiceNode> sub) {
        this.sub = sub;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

