/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.service;

import com.ds.common.JDSException;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.annotation.nav.TabsAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.enums.CustomMenuItem;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.server.JDSServer;
import com.ds.system.sys.view.service.LocalServiceFormView;
import com.ds.system.sys.view.service.RemoteServiceGridView;
import com.ds.web.util.PageUtil;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/service/msg/"})
@TabsAnnotation(closeBtn=true)
public class MsgService {
    @GridViewAnnotation
    @ModuleAnnotation(caption="\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"AllRemoteClusterSevice"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(bindMenu={CustomMenuItem.reload})
    @ResponseBody
    public ListResultModel<List<RemoteServiceGridView>> getRemoteClusterSevice() {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            userStatusInfo = PageUtil.getDefaultPageList((List)JDSServer.getInstance().getClusterSevice(), RemoteServiceGridView.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"LocalServiceInfo"})
    @DialogAnnotation(width="600", height="480")
    @FormViewAnnotation(caption="\u7f16\u8f91\u670d\u52a1\u4fe1\u606f")
    @ModuleAnnotation(imageClass="spafont spa-icon-settingprj")
    @APIEventAnnotation(bindMenu={CustomMenuItem.editor})
    @ResponseBody
    public ResultModel<LocalServiceFormView> getLocalServiceInfo(String id) {
        ResultModel resultModel = new ResultModel();
        try {
            ServiceBean serviceBean = EsbBeanFactory.getInstance().getEsbBeanById(id);
            LocalServiceFormView serviceView = new LocalServiceFormView(serviceBean);
            resultModel.setData((Object)serviceView);
        }
        catch (Exception e) {
            e.printStackTrace();
            resultModel = new ErrorListResultModel();
            ((ErrorResultModel)resultModel).setErrdes(e.getMessage());
        }
        return resultModel;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"saveService"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(callback={CustomCallBack.ReloadParent, CustomCallBack.Close})
    @ResponseBody
    public ResultModel<Boolean> savePerson(@RequestBody LocalServiceFormView service) {
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u5220\u9664\u670d\u52a1")
    @RequestMapping(value={"delService"}, method={RequestMethod.GET, RequestMethod.POST})
    @APIEventAnnotation(bindMenu={CustomMenuItem.delete}, callback={CustomCallBack.Reload, CustomCallBack.ReloadParent})
    @ResponseBody
    public ResultModel<Boolean> delService(String id) {
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }
}

