/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.service;

import com.ds.common.util.ClassUtility;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionParameter;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.action.CustomListAnnotation;
import com.ds.esd.custom.annotation.ComboListBoxAnnotation;
import com.ds.esd.custom.annotation.ComboModuleAnnotation;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.FieldAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.enums.AppendType;
import com.ds.esd.custom.form.annotation.FormAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.esd.tool.ui.enums.CustomImageType;
import com.ds.system.sys.service.ServiceNode;
import com.ds.web.annotation.Required;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@BottomBarMenu
@FormAnnotation(bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close})
public class MsgServiceFormView {
    @CustomAnnotation(caption="UID", uid=true)
    public String id;
    @Required
    @CustomAnnotation(caption="\u8def\u5f84")
    public String path;
    @CustomAnnotation(caption="\u662f\u5426", hidden=true)
    public boolean group = false;
    @Required
    @CustomAnnotation(caption="\u6807\u8bc6")
    public String key;
    @ComboListBoxAnnotation
    @CustomListAnnotation(bindClass=CustomImageType.class)
    @CustomAnnotation(caption="\u56fe\u6807")
    public String imageClass = "spafot spa-icon-c-";
    @Required
    @CustomAnnotation(caption="\u663e\u793a\u503c")
    public String caption;
    @Required
    @CustomAnnotation(caption="\u8868\u8fbe\u5f0f")
    public String expression;
    @CustomAnnotation(caption="\u53c2\u6570")
    public List<ExpressionParameter> parameters;
    @CustomAnnotation(caption="\u662f\u5426\u5c55\u5f00", hidden=true)
    public boolean iniFold = false;
    public List<ServiceNode> sub;
    public Map<String, String> tagVar = new HashMap<String, String>();

    public MsgServiceFormView(String parent, Method methodBean) {
        this.caption = methodBean.getName();
        this.id = parent + "." + methodBean.getName();
    }

    public MsgServiceFormView(ServiceBean bean) {
        this.caption = bean.getId() + "(" + (bean.getName() == null ? bean.getId() : bean.getName()) + ")";
        this.id = this.getPath();
        this.expression = bean.getExpression();
        this.parameters = bean.getParams();
        try {
            Class clazz = ClassUtility.loadClass((String)bean.getClazz());
            Method[] methods = clazz.getDeclaredMethods();
            if (methods.length > 0) {
                this.sub = new ArrayList<ServiceNode>();
                for (Method methodBean : methods) {
                    this.sub.add(new ServiceNode("$" + bean.getId(), methodBean));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public MsgServiceFormView(EsbFlowType type) {
        this.caption = type.getType() + "(" + type.getName() + ")";
        this.id = type.getType();
        List serviceBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(new EsbFlowType[]{type});
        if (serviceBeans.size() > 0) {
            this.sub = new ArrayList<ServiceNode>();
            for (ServiceBean bean : serviceBeans) {
                this.sub.add(new ServiceNode(bean));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean isIniFold() {
        return this.iniFold;
    }

    public void setIniFold(boolean iniFold) {
        this.iniFold = iniFold;
    }

    public List<ServiceNode> getSub() {
        return this.sub;
    }

    public void setSub(List<ServiceNode> sub) {
        this.sub = sub;
    }

    public Map<String, String> getTagVar() {
        return this.tagVar;
    }

    public void setTagVar(Map<String, String> tagVar) {
        this.tagVar = tagVar;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @MethodChinaName(cname="\u516c\u5f0f\u53c2\u6570")
    @ComboModuleAnnotation(append=AppendType.ref)
    @CustomAnnotation
    @FieldAnnotation(colSpan=-1, rowHeight="300")
    public List<ExpressionParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ExpressionParameter> parameters) {
        this.parameters = parameters;
    }
}

