/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.system;

import com.ds.cluster.ServerNode;
import com.ds.cluster.service.ServerEventFactory;
import com.ds.common.JDSException;
import com.ds.common.util.CnToSpell;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.annotation.ComboPopAnnotation;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.FieldAnnotation;
import com.ds.esd.custom.annotation.FileUploadAnnotation;
import com.ds.esd.custom.grid.annotation.GridAnnotation;
import com.ds.esd.custom.grid.annotation.PageBar;
import com.ds.esd.custom.grid.enums.CustomGridEvent;
import com.ds.esd.custom.grid.enums.GridMenu;
import com.ds.esd.tool.ui.enums.ComponentType;
import com.ds.org.Org;
import com.ds.org.OrgManager;
import com.ds.org.OrgNotFoundException;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;
import com.ds.server.eumus.SystemType;
import com.ds.system.sys.service.DevSystemService;
import com.ds.web.annotation.Required;
import java.util.List;

@PageBar
@GridAnnotation(customMenu={GridMenu.Reload, GridMenu.Add}, event={CustomGridEvent.editor}, customService={DevSystemService.class})
public class DevSystemGridView
implements SubSystem {
    @ComboPopAnnotation(src="AddOrg2Sys")
    @CustomAnnotation(caption="\u79df\u6237\u540d\u79f0")
    @Required
    String orgname;
    @Required
    @CustomAnnotation(caption="\u7cfb\u7edf\u540d\u79f0")
    String name;
    @ComboPopAnnotation(src="AddPerson2Sys")
    @Required
    @CustomAnnotation(caption="\u7ba1\u7406\u5458")
    String personname;
    @Required
    @CustomAnnotation(caption="\u82f1\u6587\u540d\u79f0")
    String enname;
    @FieldAnnotation(rowHeight="50", colSpan=-1)
    @CustomAnnotation(caption="\u53d1\u5e03\u5730\u5740")
    String url;
    @Required
    @CustomAnnotation(caption="\u914d\u7f6e\u9009\u9879")
    ConfigCode configname;
    @CustomAnnotation(caption="\u72b6\u6001", readonly=true)
    SystemStatus status;
    @Required
    @CustomAnnotation(caption="\u7cfb\u7edf\u7c7b\u578b")
    SystemType type;
    @CustomAnnotation(hidden=true)
    String orgId;
    @ComboPopAnnotation(src="AddSpace2Sys")
    @Required
    @CustomAnnotation(caption="\u7a7a\u95f4\u5730\u5740")
    private String vfsPath;
    @CustomAnnotation(hidden=true)
    String adminId;
    @CustomAnnotation(caption="\u8bbf\u95ee\u7c7b\u578b")
    TokenType tokenType;
    @FileUploadAnnotation(src="/system/AttachUPLoad")
    @FieldAnnotation(componentType=ComponentType.FileUpload, colSpan=-1)
    @CustomAnnotation(caption="\u7565\u7f29\u56fe")
    String icon;
    @CustomAnnotation(hidden=true)
    String personid;
    @CustomAnnotation(uid=true, hidden=true)
    String sysId;
    @CustomAnnotation(hidden=true)
    Integer serialindex = 0;
    @CustomAnnotation(hidden=true)
    String repeatEventKey = "";

    public DevSystemGridView() {
    }

    public DevSystemGridView(SubSystem subSystem) {
        this.name = subSystem.getName();
        this.enname = subSystem.getEnname();
        this.configname = subSystem.getConfigname() == null ? ConfigCode.app : subSystem.getConfigname();
        this.icon = subSystem.getIcon();
        this.orgId = subSystem.getOrgId();
        this.vfsPath = subSystem.getVfsPath();
        this.tokenType = subSystem.getTokenType() == null ? (this.tokenType = TokenType.user) : subSystem.getTokenType();
        this.adminId = subSystem.getAdminId();
        this.type = subSystem.getType() == null ? SystemType.dev : subSystem.getType();
        this.url = subSystem.getUrl() == null ? "http://" + this.enname + ".itjds.net" : subSystem.getUrl();
        this.sysId = subSystem.getSysId();
        if (this.name != null) {
            this.enname = CnToSpell.getFirstSpell((String)this.name);
        }
        OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)this.configname);
        try {
            if (this.orgId != null) {
                this.orgname = orgManager.getOrgByID(this.orgId).getName();
                this.personname = orgManager.getPersonByID(this.adminId).getName();
            }
        }
        catch (OrgNotFoundException e) {
            e.printStackTrace();
        }
        catch (PersonNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DevSystemGridView(ServerNode node) throws JDSException {
        JDSServer.getInstance();
        SubSystem subSystem = JDSServer.getClusterClient().getSystem(node.getId());
        if (subSystem == null) {
            throw new JDSException("subSystem is null systemId is[" + node.getId() + "] systemName is[" + node.getName() + "]");
        }
        OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)subSystem.getConfigname());
        this.status = JDSServer.getClusterClient().getSystemStatus(node.getId());
        this.name = subSystem.getName();
        this.enname = subSystem.getEnname();
        this.configname = subSystem.getConfigname();
        this.icon = subSystem.getIcon();
        this.orgId = subSystem.getOrgId();
        this.vfsPath = subSystem.getVfsPath();
        this.tokenType = subSystem.getTokenType();
        this.adminId = subSystem.getAdminId();
        this.type = subSystem.getType();
        if (orgManager.getTopOrgs(subSystem.getSysId()).size() > 0) {
            this.orgname = ((Org)orgManager.getTopOrgs(subSystem.getSysId()).get(0)).getName();
        }
        try {
            if (subSystem.getAdminId() != null && orgManager.getPersonByID(subSystem.getAdminId()) != null) {
                Person person = orgManager.getPersonByID(subSystem.getAdminId());
                this.personname = person.getName();
            }
        }
        catch (PersonNotFoundException e) {
            e.printStackTrace();
        }
        ServerEventFactory factory = ServerEventFactory.getInstance();
        List serviceBeans = factory.getRegisterEventByCode(node.getId());
        for (ServiceBean serviceBean : serviceBeans) {
            this.repeatEventKey = this.repeatEventKey + serviceBean.getName() + ",";
        }
        if (this.repeatEventKey.endsWith(",")) {
            this.repeatEventKey = this.repeatEventKey.substring(0, this.repeatEventKey.length() - 1);
        }
        this.type = subSystem.getType();
        this.url = subSystem.getUrl();
        this.sysId = subSystem.getSysId();
    }

    public String getRepeatEventKey() {
        return this.repeatEventKey;
    }

    public void setRepeatEventKey(String repeatEventKey) {
        this.repeatEventKey = repeatEventKey;
    }

    public String getPersonid() {
        return this.personid;
    }

    public void setPersonid(String personid) {
        this.personid = personid;
    }

    public String getOrgname() {
        return this.orgname;
    }

    public void setOrgname(String orgname) {
        this.orgname = orgname;
    }

    public String getPersonname() {
        return this.personname;
    }

    public void setPersonname(String personname) {
        this.personname = personname;
    }

    public String getEnname() {
        return this.enname;
    }

    public void setEnname(String enname) {
        this.enname = enname;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    public void setSerialindex(Integer serialindex) {
        this.serialindex = serialindex;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setVfsPath(String vfsPath) {
        this.vfsPath = vfsPath;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SystemStatus getStatus() {
        return this.status;
    }

    public void setStatus(SystemStatus status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVfsPath() {
        return this.vfsPath;
    }

    public Integer getSerialindex() {
        return this.serialindex;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ConfigCode getConfigname() {
        return this.configname;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setConfigname(ConfigCode configname) {
        this.configname = configname;
    }

    public SystemType getType() {
        return this.type;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public void setType(SystemType type) {
        this.type = type;
    }
}

