/*
 * Decompiled with CFR 0.152.
 */
package com.ds.system.sys.view.system;

import com.ds.cluster.ServerNode;
import com.ds.cluster.service.ServerEventFactory;
import com.ds.common.JDSException;
import com.ds.esb.config.TokenType;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.FieldAnnotation;
import com.ds.esd.custom.annotation.FileUploadAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.form.annotation.FormAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.esd.tool.ui.enums.ComponentType;
import com.ds.esd.tool.ui.enums.StretchType;
import com.ds.org.OrgManager;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;
import com.ds.server.eumus.SystemType;
import com.ds.system.sys.service.SystemService;
import com.ds.web.annotation.Required;
import java.util.List;

@BottomBarMenu
@FormAnnotation(stretchHeight=StretchType.last, bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close}, customService={SystemService.class})
public class SystemFormView
implements SubSystem {
    @Required
    @CustomAnnotation(caption="\u7cfb\u7edf\u540d\u79f0")
    String name;
    @Required
    @CustomAnnotation(caption="\u82f1\u6587\u540d\u79f0")
    String enname;
    @Required
    @CustomAnnotation(caption="\u7cfb\u7edf\u7c7b\u578b")
    SystemType type;
    @Required
    @CustomAnnotation(caption="\u914d\u7f6e\u9009\u9879")
    ConfigCode configname;
    @CustomAnnotation(hidden=true)
    private String vfsPath;
    @CustomAnnotation(caption="\u72b6\u6001", readonly=true)
    SystemStatus status;
    @CustomAnnotation(caption="\u8bbf\u95ee\u7c7b\u578b")
    TokenType tokenType;
    @FieldAnnotation(colWidth="120", colSpan=-1)
    @CustomAnnotation(caption="URL")
    String url;
    @FieldAnnotation(colSpan=-1, rowHeight="50")
    @CustomAnnotation(caption="\u8ba2\u9605\u6d88\u606f")
    String repeatEventKey = "";
    @CustomAnnotation(hidden=true)
    String adminId;
    @FileUploadAnnotation(src="/custom/system/AttachUPLoad")
    @FieldAnnotation(componentType=ComponentType.FileUpload, colSpan=-1)
    @CustomAnnotation(caption="\u7565\u7f29\u56fe")
    String icon;
    @CustomAnnotation(uid=true, hidden=true)
    String sysId;
    @CustomAnnotation(hidden=true)
    String orgId;
    @CustomAnnotation(hidden=true)
    Integer serialindex = 0;

    public SystemFormView() {
    }

    public SystemFormView(ServerNode node) throws JDSException {
        JDSServer.getInstance();
        SubSystem subSystem = JDSServer.getClusterClient().getSystem(node.getId());
        if (subSystem == null) {
            throw new JDSException("subSystem is null systemId is[" + node.getId() + "] systemName is[" + node.getName() + "]");
        }
        OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)subSystem.getConfigname());
        this.status = JDSServer.getClusterClient().getSystemStatus(node.getId());
        this.name = subSystem.getName();
        this.enname = subSystem.getEnname();
        this.configname = subSystem.getConfigname();
        this.icon = subSystem.getIcon();
        this.orgId = subSystem.getOrgId();
        this.vfsPath = subSystem.getVfsPath();
        this.tokenType = subSystem.getTokenType();
        this.adminId = subSystem.getAdminId();
        this.type = subSystem.getType();
        ServerEventFactory factory = ServerEventFactory.getInstance();
        List serviceBeans = factory.getRegisterEventByCode(node.getId());
        for (ServiceBean serviceBean : serviceBeans) {
            this.repeatEventKey = this.repeatEventKey + serviceBean.getName() + ",";
        }
        if (this.repeatEventKey.endsWith(",")) {
            this.repeatEventKey = this.repeatEventKey.substring(0, this.repeatEventKey.length() - 1);
        }
        this.type = subSystem.getType();
        this.url = subSystem.getUrl();
        this.sysId = subSystem.getSysId();
    }

    public String getRepeatEventKey() {
        return this.repeatEventKey;
    }

    public void setRepeatEventKey(String repeatEventKey) {
        this.repeatEventKey = repeatEventKey;
    }

    public String getEnname() {
        return this.enname;
    }

    public void setEnname(String enname) {
        this.enname = enname;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }

    public void setSerialindex(Integer serialindex) {
        this.serialindex = serialindex;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setVfsPath(String vfsPath) {
        this.vfsPath = vfsPath;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SystemStatus getStatus() {
        return this.status;
    }

    public void setStatus(SystemStatus status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVfsPath() {
        return this.vfsPath;
    }

    public Integer getSerialindex() {
        return this.serialindex;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ConfigCode getConfigname() {
        return this.configname;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setConfigname(ConfigCode configname) {
        this.configname = configname;
    }

    public SystemType getType() {
        return this.type;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public void setType(SystemType type) {
        this.type = type;
    }
}

