/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.configuration;

import cn.hutool.extra.spring.SpringUtil;
import cn.structured.basic.api.interfaces.IRepository;
import cn.structured.basic.api.model.BasicEntity;
import cn.structured.basic.core.configuration.BasicContext;
import cn.structured.basic.core.configuration.BasicProperties;
import cn.structured.basic.core.repository.impl.MemoryRepositoryImpl;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={SpringUtil.class})
@Configuration
@ComponentScan(basePackages={"cn.structured.basic.core.**"})
public class BasicAutoConfiguration {
    @Resource
    private BasicProperties properties;
    @Resource
    private BasicContext basicContext;

    @Bean
    public ThreadPoolExecutor executeThreadPool() {
        return new ThreadPoolExecutor(this.properties.getCorePoolSize(), this.properties.getMaximumPoolSize(), this.properties.getKeepAliveTime(), this.properties.getUnit(), new LinkedBlockingQueue<Runnable>(this.properties.getWorkQueue()), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Bean
    @ConditionalOnMissingBean(value={IRepository.class})
    public IRepository<BasicEntity> repository() {
        return new MemoryRepositoryImpl();
    }

    @Bean
    public BasicContext basicContext() {
        BasicContext basicContext = new BasicContext();
        basicContext.setRepository(this.repository());
        return basicContext;
    }

    @PostConstruct
    public void init() {
        List<String> addressList = this.properties.getAddressList();
        if (null != addressList) {
            addressList.forEach(address -> this.basicContext.loadResource((String)address, this.properties.getAccessToken()));
        }
    }
}

