/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.configuration;

import cn.structure.common.utils.HttpClientUtil;
import cn.structured.basic.api.enums.CallType;
import cn.structured.basic.api.enums.EntityType;
import cn.structured.basic.api.enums.NodeType;
import cn.structured.basic.api.enums.TransactionType;
import cn.structured.basic.api.enums.TriggerType;
import cn.structured.basic.api.interfaces.IRepository;
import cn.structured.basic.api.model.BasicEntity;
import cn.structured.basic.api.model.ModelEntity;
import cn.structured.basic.api.model.ViewEntity;
import cn.structured.basic.api.model.api.ApiDefinition;
import cn.structured.basic.api.model.logic.NodeDefinition;
import cn.structured.basic.api.model.logic.ProcessDefinition;
import cn.structured.basic.api.model.trigger.MessageDefinition;
import cn.structured.basic.api.model.trigger.ScheduleDefinition;
import cn.structured.basic.api.model.trigger.TriggerDefinition;
import cn.structured.basic.core.execute.CallAsync;
import cn.structured.basic.core.execute.HandleRequest;
import cn.structured.basic.core.execute.NodeExecute;
import cn.structured.basic.core.execute.ProcessExecute;
import cn.structured.basic.core.execute.transaction.AtExecute;
import cn.structured.basic.core.execute.transaction.LocalExecute;
import cn.structured.basic.core.execute.transaction.TccExecute;
import cn.structured.function.api.dataspecs.ArrayDataSpecs;
import cn.structured.function.api.dataspecs.BooleanDataSpecs;
import cn.structured.function.api.dataspecs.DateDataSpecs;
import cn.structured.function.api.dataspecs.DoubleDataSpecs;
import cn.structured.function.api.dataspecs.EnumDataSpecs;
import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.dataspecs.IntegerDataSpecs;
import cn.structured.function.api.dataspecs.LongDataSpecs;
import cn.structured.function.api.dataspecs.StructDataSpecs;
import cn.structured.function.api.dataspecs.TextDataSpecs;
import cn.structured.function.api.entity.EnumEntity;
import cn.structured.function.api.enums.DataType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContext {
    private static final Logger log = LoggerFactory.getLogger(BasicContext.class);
    private Map<String, HandleRequest> handleRequestCache = new ConcurrentHashMap<String, HandleRequest>();
    private IRepository<BasicEntity> repository;
    private String resourceVersion;

    public HandleRequest getHandleRequest(String triggerId) {
        return this.handleRequestCache.get(triggerId);
    }

    public void buildHandleRequest(TriggerDefinition triggerDefinition) {
        NodeDefinition boundNode = triggerDefinition.getBoundNode();
        HandleRequest handleRequest = null != boundNode ? new NodeExecute((BasicEntity)boundNode) : this.buildProcess(triggerDefinition);
        this.handleRequestCache.put(triggerDefinition.getId(), handleRequest);
    }

    public void loadResource(String uri, String accessToken) {
        log.info("load resource this url -> {}", (Object)uri);
        HttpClient httpClient = HttpClientUtil.getHttpClient();
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader("accessToken", accessToken);
        try {
            HttpResponse execute = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = execute.getEntity();
            InputStream content = entity.getContent();
            HashMap<String, byte[]> files = new HashMap<String, byte[]>();
            try (ZipInputStream zipInputStream = new ZipInputStream(content, StandardCharsets.UTF_8);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (entryName.lastIndexOf(".") > 0) {
                        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                            int len;
                            byte[] buf = new byte[1024];
                            while ((len = zipInputStream.read(buf, 0, buf.length)) > 0) {
                                byteArrayOutputStream.write(buf, 0, len);
                            }
                            byte[] bytes = byteArrayOutputStream.toByteArray();
                            files.put(entryName, bytes);
                        }
                    }
                    zipInputStream.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.updateVersion(files);
            content.close();
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff01 -> {} ", (Object)e.getMessage());
        }
    }

    private void updateVersion(Map<String, byte[]> files) {
        JSONObject versionContext = JSON.parseObject((String)new String(files.get("version.json"), StandardCharsets.UTF_8));
        this.resourceVersion = versionContext.getString("version");
        JSONArray resources = versionContext.getJSONArray("resources");
        for (int i = 0; i < resources.size(); ++i) {
            String fileName = resources.getString(i);
            byte[] bytes = files.get(fileName);
            String jsonStr = new String(bytes, StandardCharsets.UTF_8);
            try {
                this.loadJsonSchema(jsonStr);
                continue;
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7dJsonSchema\u9519\u8bef -> {}", (Object)e.getMessage());
            }
        }
    }

    private void loadJsonSchema(String jsonSchema) {
        final JSONObject jsonObject = JSON.parseObject((String)jsonSchema);
        String entityType = jsonObject.getString("entityType");
        ParserConfig.getGlobalInstance().putDeserializer(IDataSpecs.class, new ObjectDeserializer(){

            public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object o) {
                JSONObject contextJson = (JSONObject)defaultJSONParser.parseObject(JSONObject.class, o);
                String dataType = contextJson.getString("dataType");
                Integer length = contextJson.getInteger("length");
                String format = contextJson.getString("format");
                Integer digits = contextJson.getInteger("digits");
                String falseKey = contextJson.getString("falseKey");
                String trueKey = contextJson.getString("trueKey");
                IntegerDataSpecs dataSpecs = null;
                switch (DataType.valueOf((String)dataType)) {
                    case INT: {
                        dataSpecs = new IntegerDataSpecs(length);
                        break;
                    }
                    case DATE: {
                        dataSpecs = new DateDataSpecs(format);
                        break;
                    }
                    case DOUBLE: {
                        dataSpecs = new DoubleDataSpecs(length.intValue(), digits.intValue());
                        break;
                    }
                    case BOOL: {
                        dataSpecs = new BooleanDataSpecs(trueKey, falseKey);
                        break;
                    }
                    case ENUM: {
                        List enumEntities = jsonObject.entrySet().stream().filter(e -> ((String)e.getKey()).equals("dataType")).map(e -> new EnumEntity((String)e.getKey(), e.getValue())).collect(Collectors.toList());
                        dataSpecs = new EnumDataSpecs(enumEntities);
                        break;
                    }
                    case TEXT: {
                        dataSpecs = new TextDataSpecs(length);
                        break;
                    }
                    case ARRAY: {
                        IDataSpecs subDataSpecs = (IDataSpecs)jsonObject.getObject("subDataSpecs", IDataSpecs.class);
                        dataSpecs = new ArrayDataSpecs(subDataSpecs);
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    case STRUCT: {
                        HashMap dataSpecsMap = new HashMap();
                        jsonObject.entrySet().stream().filter(e -> ((String)e.getKey()).equals("dataType")).forEach(e -> {
                            IDataSpecs cfr_ignored_0 = (IDataSpecs)dataSpecsMap.put(e.getKey(), jsonObject.getObject((String)e.getKey(), IDataSpecs.class));
                        });
                        dataSpecs = new StructDataSpecs(dataSpecsMap);
                        break;
                    }
                    case LONG: {
                        dataSpecs = new LongDataSpecs(length);
                    }
                }
                return (T)dataSpecs;
            }

            public int getFastMatchToken() {
                return 0;
            }
        });
        BasicEntity basicEntity = null;
        switch (EntityType.valueOf((String)entityType)) {
            case NODE: {
                basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, NodeDefinition.class);
                break;
            }
            case VIEW: {
                basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, ViewEntity.class);
                break;
            }
            case EVENT: {
                String triggerType = jsonObject.getString("triggerType");
                switch (TriggerType.valueOf((String)triggerType)) {
                    case MQ: {
                        basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, MessageDefinition.class);
                        break;
                    }
                    case HTTP: {
                        basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, ApiDefinition.class);
                        String inputEntity = jsonObject.getString("inputEntity");
                        String outputEntity = jsonObject.getString("outputEntity");
                        String boundProcess = jsonObject.getString("boundProcess");
                        this.loadJsonSchema(boundProcess);
                        this.loadJsonSchema(inputEntity);
                        this.loadJsonSchema(outputEntity);
                        break;
                    }
                    case CALLBACK: {
                        basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, TriggerDefinition.class);
                        break;
                    }
                    case SCHEDULE: {
                        basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, ScheduleDefinition.class);
                    }
                }
                break;
            }
            case LOGIC: {
                basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, ProcessDefinition.class);
                JSONArray nodes = jsonObject.getJSONArray("nodes");
                for (int i = 0; i < nodes.size(); ++i) {
                    String nodeStr = nodes.getString(i);
                    this.loadJsonSchema(nodeStr);
                }
                break;
            }
            case MODEL: {
                basicEntity = (BasicEntity)JSON.parseObject((String)jsonSchema, ModelEntity.class);
            }
        }
        basicEntity.setContext(jsonSchema);
        this.repository.save((Object)basicEntity);
        if (basicEntity instanceof TriggerDefinition) {
            TriggerDefinition triggerDefinition = (TriggerDefinition)basicEntity;
            this.buildHandleRequest(triggerDefinition);
        }
    }

    private HandleRequest buildProcess(TriggerDefinition triggerDefinition) {
        ProcessDefinition boundProcess = triggerDefinition.getBoundProcess();
        List nodes = boundProcess.getNodes();
        TransactionType transactionType = boundProcess.getTransactionType();
        ProcessExecute processExecute = new ProcessExecute((BasicEntity)boundProcess);
        HandleRequest currentExecute = processExecute;
        CallType sync = triggerDefinition.getSync();
        if (sync == CallType.ASYNC) {
            CallAsync callAsync = new CallAsync();
            currentExecute.setNextHandle(callAsync);
            currentExecute = callAsync;
        }
        HandleRequest transactionExecute = null;
        switch (transactionType) {
            case AT: {
                transactionExecute = new AtExecute();
                break;
            }
            case TCC: {
                transactionExecute = new TccExecute();
                break;
            }
            case LOCAL: {
                transactionExecute = new LocalExecute();
            }
        }
        if (null != transactionExecute) {
            currentExecute.setNextHandle(transactionExecute);
            currentExecute = transactionExecute;
        }
        for (NodeDefinition node : nodes) {
            if (node.getNodeType() == NodeType.START && node.getNodeType() == NodeType.END) continue;
            currentExecute = this.setNextNode(currentExecute, node);
        }
        return processExecute;
    }

    private HandleRequest setNextNode(HandleRequest currentExecute, NodeDefinition nodeDefinition) {
        NodeExecute nodeExecute = new NodeExecute((BasicEntity)nodeDefinition);
        currentExecute.setNextHandle(nodeExecute);
        return nodeExecute;
    }

    public Map<String, HandleRequest> getHandleRequestCache() {
        return this.handleRequestCache;
    }

    public IRepository<BasicEntity> getRepository() {
        return this.repository;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setHandleRequestCache(Map<String, HandleRequest> handleRequestCache) {
        this.handleRequestCache = handleRequestCache;
    }

    public void setRepository(IRepository<BasicEntity> repository) {
        this.repository = repository;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicContext)) {
            return false;
        }
        BasicContext other = (BasicContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, HandleRequest> this$handleRequestCache = this.getHandleRequestCache();
        Map<String, HandleRequest> other$handleRequestCache = other.getHandleRequestCache();
        if (this$handleRequestCache == null ? other$handleRequestCache != null : !((Object)this$handleRequestCache).equals(other$handleRequestCache)) {
            return false;
        }
        IRepository<BasicEntity> this$repository = this.getRepository();
        IRepository<BasicEntity> other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$resourceVersion = this.getResourceVersion();
        String other$resourceVersion = other.getResourceVersion();
        return !(this$resourceVersion == null ? other$resourceVersion != null : !this$resourceVersion.equals(other$resourceVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, HandleRequest> $handleRequestCache = this.getHandleRequestCache();
        result = result * 59 + ($handleRequestCache == null ? 43 : ((Object)$handleRequestCache).hashCode());
        IRepository<BasicEntity> $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $resourceVersion = this.getResourceVersion();
        result = result * 59 + ($resourceVersion == null ? 43 : $resourceVersion.hashCode());
        return result;
    }

    public String toString() {
        return "BasicContext(handleRequestCache=" + this.getHandleRequestCache() + ", repository=" + this.getRepository() + ", resourceVersion=" + this.getResourceVersion() + ")";
    }
}

