/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.execute;

import cn.structure.common.exception.CommonException;
import cn.structured.basic.api.enums.NodeType;
import cn.structured.basic.api.model.BasicEntity;
import cn.structured.basic.api.model.logic.NodeDefinition;
import cn.structured.basic.core.execute.HandleRequest;
import cn.structured.function.api.IHandler;
import cn.structured.function.api.entity.FunctionDefinition;
import cn.structured.function.api.entity.ScriptFunction;
import cn.structured.function.api.entity.ScriptParams;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;

public class NodeExecute
extends HandleRequest {
    public NodeExecute(BasicEntity entity) {
        this.entity = entity;
    }

    private boolean inputCheckout(Object inputParam) {
        try {
            if (this.entity instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)this.entity;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean outputCheckout(Object output) {
        try {
            if (this.entity instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)this.entity;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public Object execute(Object inputParam) {
        boolean boolInput;
        NodeDefinition nodeDefinition = (NodeDefinition)this.entity;
        if (nodeDefinition.getCheckoutParam().booleanValue() && !(boolInput = this.inputCheckout(inputParam))) {
            throw new CommonException("500", "\u7ec8\u6b62\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        FunctionDefinition function = nodeDefinition.getFunction();
        IHandler handler = function.getHandler();
        if (null == handler) {
            try {
                Class<?> aClass = Class.forName(function.getName());
                handler = (IHandler)aClass.newInstance();
                function.setHandler(handler);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        Object result = null;
        if (nodeDefinition.getNodeType() == NodeType.SCRIPT) {
            ScriptParams scriptParams = this.executeScript(nodeDefinition, (Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)inputParam)));
            assert (handler != null);
            result = handler.handler((Object)scriptParams);
        }
        boolean boolOutput = this.outputCheckout(result);
        if (nodeDefinition.getCheckoutParam().booleanValue() && boolOutput) {
            throw new CommonException("500", "\u7ec8\u6b62\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        if (null != this.nextHandle) {
            return this.nextHandle.execute(result);
        }
        return result;
    }

    private ScriptParams executeScript(NodeDefinition nodeDefinition, Map<String, Object> value) {
        ScriptParams params = new ScriptParams();
        params.setCode(nodeDefinition.getScriptCode());
        ScriptFunction function = new ScriptFunction();
        function.setFunctionName(nodeDefinition.getName());
        List inputParams = nodeDefinition.getInput();
        function.setInputParams(inputParams);
        function.setOutputParams(nodeDefinition.getOutput());
        function.setInputValues(value);
        params.setFunction(function);
        return params;
    }
}

