/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.filter;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.spring.SpringUtil;
import cn.structure.common.utils.ResultUtilSimpleImpl;
import cn.structured.basic.api.interfaces.IManager;
import cn.structured.basic.api.model.BasicEntity;
import cn.structured.basic.api.model.ValueObject;
import cn.structured.basic.api.model.api.ApiDefinition;
import cn.structured.basic.core.manager.BasicManagerImpl;
import cn.structured.basic.core.manager.ExecuteServiceImpl;
import cn.structured.basic.core.manager.IExecuteService;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@Order(value=-99)
public class RouteFilter
implements Filter,
HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RouteFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        String threadName = thread.getName();
        long beginTime = System.currentTimeMillis();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String contentType = httpServletRequest.getContentType();
        String method = httpServletRequest.getMethod();
        String uri = httpServletRequest.getRequestURI();
        log.info("\u8bf7\u6c42\u65b9\u6cd5 -> {},\u4e0a\u4e0b\u6587 -> {} ,url -> {} ", new Object[]{method, contentType, uri});
        MD5 md5 = SecureUtil.md5();
        String uriDigest = md5.digestHex(uri);
        IManager entityManager = (IManager)SpringUtil.getBean(BasicManagerImpl.class);
        BasicEntity basicEntity = (BasicEntity)entityManager.findById(uriDigest);
        ApiDefinition apiDefinition = (ApiDefinition)basicEntity;
        if (null == apiDefinition) {
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (!method.equals(apiDefinition.getMethod())) {
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        Map headers = apiDefinition.getRequestHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String value;
            String header = httpServletRequest.getHeader((String)entry.getKey());
            if (header.equals(value = (String)entry.getValue())) continue;
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        StringBuilder requestBody = new StringBuilder();
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        if ("GET".equalsIgnoreCase(method)) {
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = httpServletRequest.getParameter(parameterName);
                params.put(parameterName, parameterValue);
            }
            requestBody.append(JSON.toJSONString(params));
        } else if (contentType.equals("application/json")) {
            String str;
            BufferedReader bufferedReader = request.getReader();
            while ((str = bufferedReader.readLine()) != null) {
                requestBody.append(str);
            }
            log.info(requestBody.toString());
        }
        String digestData = requestBody.toString() + uri + threadId + threadName + beginTime;
        String transactionId = md5.digestHex(digestData);
        ValueObject inputObject = new ValueObject();
        inputObject.setTransactionId(transactionId);
        inputObject.setEntity((BasicEntity)apiDefinition);
        inputObject.setValue((Object)JSON.parseObject((String)requestBody.toString()));
        IExecuteService executeService = (IExecuteService)SpringUtil.getBean(ExecuteServiceImpl.class);
        Object execute = executeService.execute(inputObject);
        response.setContentType(apiDefinition.getResponseContentType());
        ServletOutputStream outputStream = response.getOutputStream();
        if (apiDefinition.getResponseContentType().equals("application/json")) {
            outputStream.write(JSON.toJSONString((Object)ResultUtilSimpleImpl.success((Object)execute)).getBytes());
        }
        outputStream.close();
        long endTime = System.currentTimeMillis();
        log.info("\u5904\u7406\u7ed3\u675f : \u8017\u65f6 -> {}", (Object)(endTime - beginTime));
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }
}

