/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.manager;

import cn.structured.basic.api.model.ValueObject;
import cn.structured.basic.api.model.trigger.TriggerDefinition;
import cn.structured.basic.core.configuration.BasicContext;
import cn.structured.basic.core.execute.HandleRequest;
import cn.structured.basic.core.manager.IExecuteService;
import org.springframework.stereotype.Service;

@Service
public class ExecuteServiceImpl
implements IExecuteService {
    private final BasicContext basicContext;
    private final ThreadLocal<String> transaction = new ThreadLocal();

    @Override
    public Object execute(ValueObject inputParam) {
        TriggerDefinition triggerDefinition = (TriggerDefinition)inputParam.getEntity();
        this.transaction.set(inputParam.getTransactionId());
        HandleRequest handleRequest = this.basicContext.getHandleRequest(triggerDefinition.getId());
        Object result = handleRequest.execute(inputParam.getValue());
        this.transaction.remove();
        return result;
    }

    public ExecuteServiceImpl(BasicContext basicContext) {
        this.basicContext = basicContext;
    }
}

