/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.repository;

import cn.structured.basic.api.interfaces.IRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryFactory {
    private static final Map<String, Class<? extends IRepository>> REPOSITORY_REGISTER_TABLE = new ConcurrentHashMap<String, Class<? extends IRepository>>();
    private static final Map<Class<? extends IRepository>, IRepository> REPOSITORY_CACHE = new ConcurrentHashMap<Class<? extends IRepository>, IRepository>();

    public static IRepository getRepository(IRepository repository) {
        return REPOSITORY_CACHE.put(repository.getClass(), repository);
    }

    public static IRepository getRepository(Class<? extends IRepository> repositoryClass) {
        return REPOSITORY_CACHE.get(repositoryClass);
    }

    public static IRepository getRepository(String name) {
        Class<? extends IRepository> repositoryClass = REPOSITORY_REGISTER_TABLE.get(name);
        if (null == repositoryClass) {
            return null;
        }
        return REPOSITORY_CACHE.get(repositoryClass);
    }

    public static IRepository registerRepository(String name, Class<? extends IRepository> repositoryClass) {
        REPOSITORY_REGISTER_TABLE.put(name, repositoryClass);
        IRepository repository = REPOSITORY_CACHE.get(repositoryClass);
        if (null == repository) {
            try {
                repository = repositoryClass.newInstance();
                REPOSITORY_CACHE.put(repositoryClass, repository);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return repository;
    }
}

