/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.basic.core.repository.impl;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.MD5;
import cn.structured.basic.api.interfaces.IRepository;
import cn.structured.basic.api.model.BasicEntity;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryRepositoryImpl
implements IRepository<BasicEntity> {
    private static final Logger log = LoggerFactory.getLogger(MemoryRepositoryImpl.class);
    private static final Map<String, BasicEntity> ENTITY_CACHE = new ConcurrentHashMap<String, BasicEntity>();

    public Serializable save(BasicEntity basicEntity) {
        MD5 md5 = SecureUtil.md5();
        String id = md5.digestHex(basicEntity.getPath());
        basicEntity.setId(id);
        ENTITY_CACHE.put(id, basicEntity);
        log.info("\u52a0\u8f7dEntity INFO : id -> {},name -> {} ,entityType  ->{}", new Object[]{id, basicEntity.getName(), basicEntity.getEntityType()});
        return id;
    }

    public boolean updateById(Serializable id, BasicEntity basicEntity) {
        ENTITY_CACHE.put(id.toString(), basicEntity);
        return true;
    }

    public boolean removeById(Serializable id) {
        ENTITY_CACHE.remove(id.toString());
        return true;
    }

    public BasicEntity findById(Serializable id) {
        return ENTITY_CACHE.get(id.toString());
    }
}

