/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.cache.file;

import cn.ujava.common.cache.Cache;
import cn.ujava.common.cache.file.AbstractFileCache;
import cn.ujava.common.cache.impl.LRUCache;
import java.io.File;

public class LRUFileCache
extends AbstractFileCache {
    private static final long serialVersionUID = 1L;

    public LRUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        return new LRUCache<File, byte[]>(this.capacity, this.timeout){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isFull() {
                return LRUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LRUFileCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

