/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.codec.hash;

import cn.ujava.common.codec.hash.Hash32;
import cn.ujava.common.codec.hash.HashUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Hash32<Object> hashFunc;
    private final int numberOfReplicas;
    private final SortedMap<Integer, T> circle = new TreeMap<Integer, T>();

    public ConsistentHash(int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        this.hashFunc = key -> HashUtil.fnvHash(key.toString());
        for (T node : nodes) {
            this.add(node);
        }
    }

    public ConsistentHash(Hash32<Object> hashFunc, int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        this.hashFunc = hashFunc;
        for (T node : nodes) {
            this.add(node);
        }
    }

    public void add(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hashFunc.hash32(node.toString() + i), node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hashFunc.hash32(node.toString() + i));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFunc.hash32(key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (T)this.circle.get(hash);
    }
}

