/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.collection.iter;

import cn.ujava.common.collection.iter.IterableIter;
import cn.ujava.common.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class PartitionIter<T>
implements IterableIter<List<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Iterator<T> iterator;
    protected final int partitionSize;

    public PartitionIter(Iterator<T> iterator, int partitionSize) {
        Assert.isTrue(partitionSize > 0, "partition size must greater than 0", new Object[0]);
        this.iterator = Objects.requireNonNull(iterator);
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> next() {
        ArrayList<T> list = new ArrayList<T>(this.partitionSize);
        for (int i = 0; i < this.partitionSize && this.iterator.hasNext(); ++i) {
            list.add(this.iterator.next());
        }
        return list;
    }
}

