/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.compress;

import cn.ujava.common.compress.ZipResource;
import cn.ujava.common.compress.ZipSecurityUtil;
import cn.ujava.common.compress.ZipUtil;
import cn.ujava.common.io.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileResource
implements ZipResource {
    private final ZipFile zipFile;

    public ZipFileResource(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(ZipSecurityUtil.checkZipBomb(em.nextElement(), maxSizeDiff));
        }
    }

    @Override
    public InputStream get(String path) {
        ZipFile zipFile = this.zipFile;
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipUtil.getStream(zipFile, entry);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return ZipUtil.getStream(this.zipFile, entry);
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(this.zipFile);
    }
}

