/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.compress;

import cn.ujava.common.collection.iter.EnumerationIter;
import cn.ujava.common.compress.Deflate;
import cn.ujava.common.compress.Gzip;
import cn.ujava.common.compress.ZipCopyVisitor;
import cn.ujava.common.compress.ZipReader;
import cn.ujava.common.compress.ZipWriter;
import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.file.FileNameUtil;
import cn.ujava.common.io.file.FileSystemUtil;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.file.PathUtil;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.io.stream.FastByteArrayOutputStream;
import cn.ujava.common.io.stream.LimitedInputStream;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.ByteUtil;
import cn.ujava.common.util.CharsetUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.defaultCharset();

    public static ZipFile toZipFile(File file, Charset charset) {
        try {
            return new ZipFile(file, ObjUtil.defaultIfNull(charset, CharsetUtil.UTF_8));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getStream(ZipFile zipFile, ZipEntry zipEntry) {
        try {
            return new LimitedInputStream(zipFile.getInputStream(zipEntry), zipEntry.getSize());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    public static void append(Path zipPath, Path appendFilePath, CopyOption ... options) throws IORuntimeException {
        try (FileSystem zipFileSystem2 = FileSystemUtil.createZip(zipPath.toString());){
            if (Files.isDirectory(appendFilePath, new LinkOption[0])) {
                Path source = appendFilePath.getParent();
                if (null == source) {
                    source = appendFilePath;
                }
                Files.walkFileTree(appendFilePath, new ZipCopyVisitor(source, zipFileSystem2, options));
            } else {
                Files.copy(appendFilePath, zipFileSystem2.getPath(PathUtil.getName(appendFilePath), new String[0]), options);
            }
        }
        catch (FileAlreadyExistsException zipFileSystem2) {
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File zip(String srcPath) throws HutoolException {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws HutoolException {
        return ZipUtil.zip(FileUtil.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws HutoolException {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws HutoolException {
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileNameUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws HutoolException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws HutoolException {
        return ZipUtil.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws HutoolException {
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws HutoolException {
        return ZipUtil.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws HutoolException {
        return ZipUtil.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        ZipUtil.validateFiles(zipFile, srcFiles);
        ZipWriter.of(zipFile, charset).add(withSrcDir, filter, srcFiles).close();
        return zipFile;
    }

    public static void zip(OutputStream out, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        ZipWriter.of(out, charset).add(withSrcDir, filter, srcFiles).close();
    }

    public static File zip(File zipFile, String path, String data) throws HutoolException {
        return ZipUtil.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) throws HutoolException {
        return ZipUtil.zip(zipFile, path, IoUtil.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws HutoolException {
        return ZipUtil.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws HutoolException {
        return ZipUtil.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws HutoolException {
        return ZipUtil.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) throws HutoolException {
        try (ZipWriter zipWriter = ZipWriter.of(zipFile, charset);){
            zipWriter.add(paths, ins);
        }
        return zipFile;
    }

    public static void zip(OutputStream out, String[] paths, InputStream[] ins) {
        ZipUtil.zip(ZipUtil.getZipOutputStream(out, DEFAULT_CHARSET), paths, ins);
    }

    public static void zip(ZipOutputStream zipOutputStream, String[] paths, InputStream[] ins) throws IORuntimeException {
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            zipWriter.add(paths, ins);
        }
    }

    public static File zip(File zipFile, Charset charset, Resource ... resources) throws HutoolException {
        ZipWriter.of(zipFile, charset).add(resources).close();
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws HutoolException {
        return ZipUtil.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) throws HutoolException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws HutoolException {
        return ZipUtil.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) throws HutoolException {
        File destDir = FileUtil.file(zipFile.getParentFile(), FileNameUtil.mainName(zipFile));
        return ZipUtil.unzip(zipFile, destDir, charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws HutoolException {
        return ZipUtil.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws HutoolException {
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws HutoolException {
        return ZipUtil.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) {
        return ZipUtil.unzip(ZipUtil.toZipFile(zipFile, charset), outFile);
    }

    public static File unzip(ZipFile zipFile, File outFile) throws IORuntimeException {
        return ZipUtil.unzip(zipFile, outFile, -1L);
    }

    public static File unzip(ZipFile zipFile, File outFile, long limit) throws IORuntimeException {
        if (outFile.exists() && outFile.isFile()) {
            throw new IllegalArgumentException(StrUtil.format("Target path [{}] exist!", outFile.getAbsolutePath()));
        }
        if (limit > 0L) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            long zipFileSize = 0L;
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if ((zipFileSize += zipEntry.getSize()) <= limit) continue;
                throw new IllegalArgumentException("The file size exceeds the limit");
            }
        }
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static InputStream get(File zipFile, Charset charset, String path) {
        return ZipUtil.get(ZipUtil.toZipFile(zipFile, charset), path);
    }

    public static InputStream get(ZipFile zipFile, String path) {
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipUtil.getStream(zipFile, entry);
        }
        return null;
    }

    public static void read(ZipFile zipFile, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.read(consumer);
        }
    }

    public static File unzip(InputStream in, File outFile, Charset charset) throws HutoolException {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtil.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) throws HutoolException {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static void read(ZipInputStream zipStream, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.read(consumer);
        }
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipUtil.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) {
        return ZipUtil.unzipFileBytes(FileUtil.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipUtil.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) {
        try (ZipReader reader = ZipReader.of(zipFile, charset);){
            byte[] byArray = IoUtil.readBytes(reader.get(name));
            return byArray;
        }
    }

    public static byte[] gzip(String content, Charset charset) throws HutoolException {
        return ZipUtil.gzip(ByteUtil.toBytes(content, charset));
    }

    public static byte[] gzip(byte[] buf) throws HutoolException {
        return ZipUtil.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws HutoolException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byArray = ZipUtil.gzip(in, (int)file.length());
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return byArray;
    }

    public static byte[] gzip(InputStream in) throws HutoolException {
        return ZipUtil.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws HutoolException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(in, bos).gzip().close();
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, Charset charset) throws HutoolException {
        return StrUtil.str(ZipUtil.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws HutoolException {
        return ZipUtil.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws HutoolException {
        return ZipUtil.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws HutoolException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(length);
        Gzip.of(in, bos).unGzip().close();
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, Charset charset, int level) {
        return ZipUtil.zlib(ByteUtil.toBytes(content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byArray = ZipUtil.zlib(in, level, (int)file.length());
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return byArray;
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipUtil.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipUtil.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).deflater(level);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, Charset charset) {
        return StrUtil.str(ZipUtil.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipUtil.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtil.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).inflater();
        return out.toByteArray();
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StrUtil.isNotBlank(dir)) {
            dir = StrUtil.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : new EnumerationIter<ZipEntry>(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StrUtil.isEmpty(dir) && !name.startsWith(dir) || !StrUtil.isNotEmpty(nameSuffix = StrUtil.removePrefix(name, dir)) || StrUtil.contains((CharSequence)nameSuffix, '/')) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws HutoolException {
        if (zipFile.isDirectory()) {
            throw new HutoolException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            File parentFile;
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new HutoolException(StrUtil.format("File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                parentFile = zipFile.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                parentFile = zipFile.getParentFile();
            }
            if (!srcFile.isDirectory() || !FileUtil.isSub(srcFile, parentFile)) continue;
            throw new HutoolException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getPath(), srcFile.getPath());
        }
    }
}

