/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.convert.CastUtil;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.reflect.TypeUtil;
import cn.ujava.common.text.CharUtil;
import java.io.Serializable;
import java.lang.reflect.Type;

public abstract class AbstractConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (TypeUtil.isUnknown(targetType)) {
            throw new ConvertException("Unsupported convert to unKnown type: {}", targetType);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        if (null == targetClass) {
            throw new ConvertException("Target type [{}] is not a class!", targetType);
        }
        if (targetClass.isInstance(value)) {
            return CastUtil.castTo(targetClass, value);
        }
        return this.convertInternal(targetClass, value);
    }

    protected abstract Object convertInternal(Class<?> var1, Object var2);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtil.isArray(value)) {
            return ArrayUtil.toString(value);
        }
        if (CharUtil.isChar(value)) {
            return CharUtil.toString(((Character)value).charValue());
        }
        return value.toString();
    }
}

