/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.func;

import cn.ujava.common.exception.ExceptionUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

@FunctionalInterface
public interface SerPredicate<T>
extends Predicate<T>,
Serializable {
    public boolean testing(T var1) throws Exception;

    @Override
    default public boolean test(T t) {
        try {
            return this.testing(t);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    @SafeVarargs
    public static <T> SerPredicate<T> multiAnd(SerPredicate<T> ... predicates) {
        return Stream.of(predicates).reduce(SerPredicate::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> SerPredicate<T> multiOr(SerPredicate<T> ... predicates) {
        return Stream.of(predicates).reduce(SerPredicate::or).orElseGet(() -> o -> false);
    }

    public static <T> SerPredicate<T> isEqual(Object ... targetRef) {
        return null == targetRef ? Objects::isNull : object -> Stream.of(targetRef).allMatch(target -> target.equals(object));
    }

    @Override
    default public SerPredicate<T> and(SerPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public SerPredicate<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public SerPredicate<T> or(SerPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

