/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.copy;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.StreamProgress;
import cn.ujava.common.io.copy.IoCopier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelCopier
extends IoCopier<ReadableByteChannel, WritableByteChannel> {
    public ChannelCopier() {
        this(8192);
    }

    public ChannelCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public ChannelCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public ChannelCopier(int bufferSize, long count, StreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(ReadableByteChannel source, WritableByteChannel target) {
        long size;
        StreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, ByteBuffer.allocate(this.bufferSize(this.count)), progress);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(this.count < Long.MAX_VALUE ? this.count : -1L, total);
        }
        return total;
    }
}

