/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.io.file.FileWriter;
import cn.ujava.common.thread.lock.LockUtil;
import cn.ujava.common.util.CharsetUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class FileAppender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FileWriter writer;
    private final int capacity;
    private final boolean isNewLineMode;
    private final List<String> list;
    private final Lock lock;

    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this(destFile, CharsetUtil.UTF_8, capacity, isNewLineMode);
    }

    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode) {
        this(destFile, charset, capacity, isNewLineMode, null);
    }

    public FileAppender(File destFile, Charset charset, int capacity, boolean isNewLineMode, Lock lock) {
        this.capacity = capacity;
        this.list = new ArrayList<String>(capacity);
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.of(destFile, charset);
        this.lock = ObjUtil.defaultIfNull(lock, LockUtil::getNoLock);
    }

    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.lock.lock();
        try {
            this.list.add(line);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAppender flush() {
        this.lock.lock();
        try {
            try (PrintWriter pw = this.writer.getPrintWriter(true);){
                for (String str : this.list) {
                    pw.print(str);
                    if (!this.isNewLineMode) continue;
                    pw.println();
                }
            }
            this.list.clear();
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }
}

