/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.resource;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.ByteUtil;
import cn.ujava.common.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;

public class CharSequenceResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CharSequence data;
    private final CharSequence name;
    private final Charset charset;

    public CharSequenceResource(CharSequence data) {
        this(data, null);
    }

    public CharSequenceResource(CharSequence data, String name) {
        this(data, name, CharsetUtil.UTF_8);
    }

    public CharSequenceResource(CharSequence data, CharSequence name, Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return StrUtil.str(this.name);
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.toBuffered(new StringReader(this.data.toString()));
    }

    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        return this.data.toString();
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        return ByteUtil.toBytes(this.data, this.charset);
    }
}

