/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.resource;

import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.collection.iter.EnumerationIter;
import cn.ujava.common.collection.iter.IterUtil;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.resource.ClassPathResource;
import cn.ujava.common.io.resource.FileResource;
import cn.ujava.common.io.resource.MultiResource;
import cn.ujava.common.io.resource.NoResourceException;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.io.resource.UrlResource;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.CharsetUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class ResourceUtil {
    public static String readUtf8Str(String resource) {
        return ResourceUtil.getResource(resource).readUtf8Str();
    }

    public static String readStr(String resource, Charset charset) {
        return ResourceUtil.getResource(resource).readStr(charset);
    }

    public static byte[] readBytes(String resource) {
        return ResourceUtil.getResource(resource).readBytes();
    }

    public static InputStream getStream(String resource) throws NoResourceException {
        return ResourceUtil.getResource(resource).getStream();
    }

    public static InputStream getStreamSafe(String resource) {
        try {
            return ResourceUtil.getResource(resource).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static BufferedReader getUtf8Reader(String resource) {
        return ResourceUtil.getReader(resource, CharsetUtil.UTF_8);
    }

    public static BufferedReader getReader(String resource, Charset charset) {
        return ResourceUtil.getResource(resource).getReader(charset);
    }

    public static URL getResourceUrl(String resource) throws IORuntimeException {
        return ResourceUtil.getResourceUrl(resource, null);
    }

    public static List<URL> getResourceUrls(String resource) {
        return ResourceUtil.getResourceUrls(resource, null);
    }

    public static List<URL> getResourceUrls(String resource, Predicate<URL> filter) {
        return IterUtil.filterToList(ResourceUtil.getResourceUrlIter(resource), filter);
    }

    public static EnumerationIter<URL> getResourceUrlIter(String resource) {
        return ResourceUtil.getResourceUrlIter(resource, null);
    }

    public static EnumerationIter<URL> getResourceUrlIter(String resource, ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = ObjUtil.defaultIfNull(classLoader, ClassLoaderUtil::getClassLoader).getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        resource = StrUtil.emptyIfNull(resource);
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtil.getClassLoader().getResource(resource);
    }

    public static Resource getResource(String path) {
        if (StrUtil.isNotBlank(path) && (path.startsWith("file:") || FileUtil.isAbsolutePath(path))) {
            return new FileResource(path);
        }
        return new ClassPathResource(path);
    }

    public static Resource getResource(URL url) {
        return new UrlResource(url);
    }

    public static Resource getResource(File file) {
        return new FileResource(file);
    }

    public static MultiResource getResources(String resource) {
        return ResourceUtil.getResources(resource, null);
    }

    public static MultiResource getResources(String resource, ClassLoader classLoader) {
        EnumerationIter<URL> iter = ResourceUtil.getResourceUrlIter(resource, classLoader);
        MultiResource resources = new MultiResource(new Resource[0]);
        for (URL url : iter) {
            resources.add(ResourceUtil.getResource(url));
        }
        return resources;
    }

    public static void loadTo(Properties properties, Resource resource, Charset charset) {
        block29: {
            Assert.notNull(properties);
            Assert.notNull(resource);
            String filename = resource.getName();
            if (filename != null && StrUtil.endWithIgnoreCase(filename, ".xml")) {
                try (InputStream in = resource.getStream();){
                    properties.loadFromXML(in);
                    break block29;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            try (BufferedReader reader = resource.getReader(ObjUtil.defaultIfNull(charset, CharsetUtil.UTF_8));){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static void loadAllTo(Properties properties, String resourceName, ClassLoader classLoader, Charset charset, boolean isOverride) {
        if (isOverride) {
            for (Resource resource : ResourceUtil.getResources(resourceName, classLoader)) {
                ResourceUtil.loadTo(properties, resource, charset);
            }
            return;
        }
        Properties tmpProps = new Properties();
        for (Resource resource : ResourceUtil.getResources(resourceName, classLoader)) {
            ResourceUtil.loadTo(tmpProps, resource, charset);
            tmpProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> {
                if (!properties.containsKey(name)) {
                    properties.put(name, value);
                }
            }));
        }
    }
}

