/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.resource;

import cn.ujava.common.io.file.FileNameUtil;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.resource.NoResourceException;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.net.url.URLUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL url;
    private long lastModified = 0L;
    protected String name;

    public UrlResource(URI uri) {
        this(URLUtil.url(uri), null);
    }

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        if (null != url && "file".equals(url.getProtocol())) {
            this.lastModified = FileUtil.file(url).lastModified();
        }
        this.name = ObjUtil.defaultIfNull(name, () -> null != url ? FileNameUtil.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long size() {
        return URLUtil.size(this.url);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (null == this.url) {
            throw new NoResourceException("Resource URL is null!");
        }
        return URLUtil.getStream(this.url);
    }

    @Override
    public boolean isModified() {
        return 0L != this.lastModified && this.lastModified != this.getFile().lastModified();
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

